/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.render;

import com.google.common.collect.Maps;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelRender
extends Render {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel;charset=" + ExcelRender.getEncoding();
    private Map<String, Object> beans = Maps.newHashMap();
    private String filename = "file1.xls";
    private String templetFile;

    public static ExcelRender me(String templetFile) {
        return new ExcelRender(templetFile);
    }

    public ExcelRender(String templetFile) {
        this.templetFile = templetFile;
    }

    public ExcelRender beans(Map<String, Object> beans) {
        this.beans = beans;
        return this;
    }

    private void buildBean() {
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String key = (String)attrs.nextElement();
            Object value = this.request.getAttribute(key);
            this.beans.put(key, value);
        }
    }

    public ExcelRender filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Override
    public void render() {
        if (this.beans.isEmpty()) {
            this.buildBean();
        }
        this.response.setContentType(CONTENT_TYPE);
        this.response.setHeader("Content-Disposition", "attachment;Filename=" + this.filename);
        ServletOutputStream out = null;
        InputStream is = null;
        Workbook workBook = null;
        try {
            out = this.response.getOutputStream();
            is = new BufferedInputStream(new FileInputStream(this.templetFile));
            XLSTransformer transformer = new XLSTransformer();
            workBook = transformer.transformXLS(is, this.beans);
            workBook.write((OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RenderException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ExcelRender templetFile(String templetFile) {
        this.templetFile = templetFile;
        return this;
    }
}

