/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.route;

import com.domeke.core.kit.ClassSearcher;
import com.domeke.core.route.ControllerBind;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jfinal.config.Routes;
import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoBindRoutes
extends Routes {
    private boolean autoScan = true;
    private List<Class<? extends Controller>> excludeClasses = Lists.newArrayList();
    private boolean includeAllJarsInLib;
    private List<String> includeJars = Lists.newArrayList();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String suffix = "Controller";

    public AutoBindRoutes autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoBindRoutes addExcludeClasses(Class<? extends Controller> ... clazzes) {
        if (clazzes != null) {
            for (Class<? extends Controller> clazz : clazzes) {
                this.excludeClasses.add(clazz);
            }
        }
        return this;
    }

    public AutoBindRoutes addExcludeClasses(List<Class<? extends Controller>> clazzes) {
        this.excludeClasses.addAll(clazzes);
        return this;
    }

    public AutoBindRoutes addJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    @Override
    public void config() {
        List controllerClasses = ClassSearcher.of(Controller.class).includeAllJarsInLib(this.includeAllJarsInLib).injars(this.includeJars).search();
        ControllerBind controllerBind = null;
        for (Class<Controller> clazz : controllerClasses) {
            if (this.excludeClasses.contains(clazz)) continue;
            controllerBind = clazz.getAnnotation(ControllerBind.class);
            if (controllerBind == null) {
                if (!this.autoScan) continue;
                this.add(this.controllerKey(clazz), clazz);
                this.logger.debug("routes.add(" + this.controllerKey(clazz) + ", " + clazz.getName() + ")");
                continue;
            }
            if (StrKit.isBlank(controllerBind.viewPath())) {
                this.add(controllerBind.controllerKey(), clazz);
                this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + clazz.getName() + ")");
                continue;
            }
            this.add(controllerBind.controllerKey(), clazz, controllerBind.viewPath());
            this.logger.debug("routes.add(" + controllerBind.controllerKey() + ", " + clazz + "," + controllerBind.viewPath() + ")");
        }
    }

    private String controllerKey(Class<Controller> clazz) {
        Preconditions.checkArgument((boolean)clazz.getSimpleName().endsWith(this.suffix), (Object)(" does not has a @ControllerBind annotation and it's name is not end with " + this.suffix));
        String controllerKey = "/" + StrKit.firstCharToLowerCase(clazz.getSimpleName());
        controllerKey = controllerKey.substring(0, controllerKey.indexOf(this.suffix));
        return controllerKey;
    }

    public AutoBindRoutes includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }

    public AutoBindRoutes suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }
}

