/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.service.BaseService;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeService
extends BaseService
implements ICacheService {
    private Logger logger = LoggerFactory.getLogger(CodeService.class);
    private static Map<String, Record> codeTableMap;
    private static Map<String, Map<String, Record>> codeTypeMap;

    @Override
    public void cacheAll() {
        this.cacheCode();
        this.cacheCodeList();
    }

    private void cacheCode() {
        String sql = this.getSql("domeke.core.codeTable.queryCodeTabeList");
        List<Record> list = Db.find(sql);
        this.logger.info("cache code start ====");
        this.logger.info("cache code size {}====", (Object)list.size());
        String cacheKey = "";
        String codeType = "";
        String codeKey = "";
        for (Record codeTable : list) {
            codeType = (String)codeTable.get("CODETYPE");
            codeKey = (String)codeTable.get("CODEKEY");
            cacheKey = codeType + "_" + codeKey;
            CacheKit.put("system", "dict_" + cacheKey.toUpperCase(), codeTable.getStr("codevalue"));
            CacheKit.put("system", "dict_name_" + cacheKey.toUpperCase(), codeTable.getStr("codevalue"));
        }
        this.logger.info("cache code end ====");
    }

    public void cacheCodeList() {
        String sql = this.getSql("domeke.core.codetype.quertAllCodeType");
        List<Record> codeTypelist = Db.find(sql);
        sql = this.getSql("domeke.core.codeTable.queryCodeTabeList");
        List<Record> codeTablelist = Db.find(sql);
        ArrayList cacheList = Lists.newArrayList();
        String type = "";
        for (Record codeType : codeTypelist) {
            cacheList = Lists.newArrayList();
            type = (String)codeType.get("codetype");
            for (Record codeTable : codeTablelist) {
                if (!type.equals(codeTable.get("codetype"))) continue;
                cacheList.add(codeTable);
            }
            CacheKit.put("system", "dict_" + type, cacheList);
            this.logger.info("cache codeType {} list {} end ====", (Object)type, (Object)cacheList.size());
        }
    }

    @Override
    public void removeCache() {
    }

    @Override
    public void removeCache(String cacheKey) {
    }

    @Override
    public <T> T getCache(String cacheKey) {
        return CacheKit.get("system", cacheKey);
    }
}

