/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictAreaService
implements ICacheService {
    private Logger logger = LoggerFactory.getLogger(DistrictAreaService.class);

    @Override
    public void cacheAll() {
        this.cacheAreaList();
        this.cacheArea();
    }

    @Override
    public void removeCache() {
    }

    @Override
    public void removeCache(String cacheKey) {
    }

    @Override
    public <T> T getCache(String cacheKey) {
        return null;
    }

    private void cacheAreaList() {
        List<Record> allCityList = District.dao.getCityList();
        ArrayList areaList = Lists.newArrayList();
        List<Record> AllAreaList = District.dao.getAreaList();
        for (Record record : allCityList) {
            areaList = Lists.newArrayList();
            String cityKey = record.getStr("codeKey");
            for (Record cityRecord : AllAreaList) {
                String parentid = cityRecord.getStr("parentid");
                if (!cityKey.equalsIgnoreCase(parentid)) continue;
                areaList.add(cityRecord);
            }
            CacheKit.put("system", "district_area_list_" + cityKey, areaList);
            this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1a{} Area end  cache size{} ", (Object)record.getStr("SHORTNAME"), (Object)areaList.size());
        }
    }

    private void cacheArea() {
        List<Record> areaList = District.dao.getAreaList();
        for (Record record : areaList) {
            String codekey = record.getStr("codekey");
            CacheKit.put("system", "district_area_" + codekey, record);
        }
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aArea end  cache size {} ", (Object)areaList.size());
    }
}

