/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictCityService
implements ICacheService {
    private Logger logger = LoggerFactory.getLogger(DistrictCityService.class);

    @Override
    public void cacheAll() {
        this.cacheCityList();
        this.cacheCity();
    }

    @Override
    public void removeCache() {
    }

    @Override
    public void removeCache(String cacheKey) {
    }

    @Override
    public <T> T getCache(String cacheKey) {
        return null;
    }

    private void cacheCity() {
        List<Record> cityList = District.dao.getCityList();
        for (Record record : cityList) {
            String codekey = record.getStr("codekey");
            CacheKit.put("system", "district_city_" + codekey, record);
        }
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aCity end  cache size{} ", (Object)cityList.size());
    }

    private void cacheCityList() {
        List<Record> allCityList = District.dao.getCityList();
        ArrayList cityList = Lists.newArrayList();
        List<Record> provinceList = District.dao.getProvinceList();
        for (Record record : provinceList) {
            cityList = Lists.newArrayList();
            String provinceKey = record.getStr("codeKey");
            for (Record cityRecord : allCityList) {
                String parentid = cityRecord.getStr("parentid");
                if (!provinceKey.equalsIgnoreCase(parentid)) continue;
                cityList.add(cityRecord);
            }
            CacheKit.put("system", "district_city_list_" + provinceKey, cityList);
            this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1a{} CityList end  cache size{} ", (Object)record.getStr("SHORTNAME"), (Object)cityList.size());
        }
    }
}

