/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.model.District;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictService
implements ICacheService {
    private Logger logger = LoggerFactory.getLogger(DistrictService.class);

    @Override
    public void cacheAll() {
        this.cacheProvinceList();
        this.cacheProvince();
        this.cacheDistrict();
    }

    @Override
    public void removeCache() {
    }

    @Override
    public void removeCache(String cacheKey) {
    }

    public District getCache(String cacheKey) {
        return (District)CacheKit.get("system", cacheKey);
    }

    public void cacheProvince() {
        List<Record> provinceList = District.dao.getProvinceList();
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aProvince start");
        for (Record record : provinceList) {
            String codekey = record.getStr("codekey");
            CacheKit.put("system", "district_province_" + codekey, record);
        }
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aProvince end  cache size {} ", (Object)provinceList.size());
    }

    public void cacheProvinceList() {
        List<Record> provinceList = District.dao.getProvinceList();
        CacheKit.put("system", "district_province_list_", provinceList);
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aProvince end  cache size {} ", (Object)provinceList.size());
    }

    public void cacheDistrict() {
        List<Record> provinceList = District.dao.getAll();
        for (Record record : provinceList) {
            String codekey = record.getStr("codekey");
            CacheKit.put("system", "district_" + codekey, record);
        }
    }
}

