/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.model.Menu;
import com.domeke.core.service.BaseService;
import com.domeke.core.service.cache.ICacheService;
import com.google.common.collect.Lists;
import com.jfinal.plugin.ehcache.CacheKit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuService
extends BaseService
implements ICacheService {
    public static final MenuService SERVICE = new MenuService();
    private Logger logger = LoggerFactory.getLogger(MenuService.class);
    StringBuffer returnStr = new StringBuffer();

    @Override
    public void cacheAll() {
        this.cacheAdminMenu();
    }

    private void cacheAdminMenu() {
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aMenu start");
        String sql = this.getSql("domeke.core.menu.queryMenuByModuleId");
        List menuList = Menu.dao.find(sql, 1);
        this.logger.info("admin menu list size = {}", (Object)menuList.size());
        CacheKit.put("system", "admin_menu_", menuList);
        List<Object> childMenuList = Lists.newArrayList();
        for (Menu menu : menuList) {
            sql = this.getSql("domeke.core.menu.queryMenuChild");
            childMenuList = Menu.dao.find(sql, menu.getPKValue());
            CacheKit.put("system", "admin_menu_" + menu.getPKValue(), childMenuList);
        }
        this.logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aMenu end, size = " + menuList.size());
    }

    @Override
    public void removeCache(String cachekey) {
        CacheKit.remove("system", cachekey);
        CacheKit.remove("system", cachekey);
    }

    public Menu getCache(String cacheName) {
        Menu menu = (Menu)CacheKit.get("system", cacheName);
        return menu;
    }

    @Override
    public void removeCache() {
        CacheKit.remove("system", "admin_menu_");
        CacheKit.remove("system", "index_menu_");
    }

    public Menu queryMenuById(String id) {
        Menu menu = (Menu)Menu.dao.findById((Object)id);
        return menu;
    }

    public List<Menu> queryMenuChild(String id) {
        String sql = this.getSql("domeke.core.menu.queryMenuChild");
        List<Menu> menuList = Menu.dao.find(sql, id);
        return menuList;
    }

    public List<Menu> queryMenuParent() {
        String sql = this.getSql("domeke.core.menu.queryMenuParent");
        List<Menu> menuList = Menu.dao.find(sql);
        return menuList;
    }

    public List<Menu> queryAllMenu() {
        String sql = this.getSql("domeke.core.menu.queryAllMenu");
        List<Menu> menuList = Menu.dao.find(sql);
        return menuList;
    }

    public Object queryMenuTree() {
        List<Menu> menuList = this.queryAllMenu();
        List<Menu> menuParent = this.queryMenuParent();
        int i = 0;
        for (Menu menu : menuParent) {
            if (i == 0) {
                this.returnStr.setLength(0);
            }
            this.recursionFn(menuList, menu);
            ++i;
        }
        String menuJson = this.modifyStr(this.returnStr.toString());
        return menuJson;
    }

    public Menu recursiveTree(String menuId) {
        Menu menu = this.queryMenuById(menuId);
        List<Menu> childTreeNodes = this.queryMenuChild(menuId);
        for (Menu child : childTreeNodes) {
            Menu m;
            menu = m = this.recursiveTree(child.getStr("menuid"));
        }
        return menu;
    }

    public void recursionFn(List<Menu> list, Menu node) {
        if (this.hasChild(list, node)) {
            this.returnStr.append("{id:");
            this.returnStr.append("'" + node.getStr("menuid") + "'");
            this.returnStr.append(",name:");
            this.returnStr.append("'" + node.getStr("menuname") + "'");
            this.returnStr.append(",parent:");
            this.returnStr.append("'" + node.getStr("parentmenuid") + "'");
            this.returnStr.append(",childrens:[");
            List<Menu> childList = this.getChildList(list, node);
            for (Menu n : childList) {
                this.recursionFn(list, n);
            }
            this.returnStr.append("]},");
        } else {
            this.returnStr.append("{id:");
            this.returnStr.append("'" + node.getStr("menuid") + "'");
            this.returnStr.append(",name:");
            this.returnStr.append("'" + node.getStr("menuname") + "'");
            this.returnStr.append("},");
        }
    }

    public boolean hasChild(List<Menu> list, Menu node) {
        return this.getChildList(list, node).size() > 0;
    }

    public List<Menu> getChildList(List<Menu> list, Menu node) {
        ArrayList<Menu> li = new ArrayList<Menu>();
        for (Menu n : list) {
            if (!node.getStr("menuid").equals(n.getStr("parentmenuid"))) continue;
            li.add(n);
        }
        return li;
    }

    public String modifyStr(String returnStr) {
        return ("[" + returnStr + "]").replaceAll(",]", "]");
    }
}

