/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.service;

import com.domeke.core.model.Company;
import com.domeke.core.model.User;
import com.domeke.core.service.BaseService;
import com.domeke.core.service.cache.ICacheService;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.redis.Redis;
import java.util.List;
import java.util.Map;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService
extends BaseService
implements ICacheService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    public static final UserService SERVICE = new UserService();

    public User login(String username) {
        return User.dao.login(username);
    }

    public void save(User user) {
        String password = user.getStr("password");
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        String salt = rng.nextBytes().toHex();
        String hashedPasswordBase64 = new Sha256Hash((Object)password).toHex();
        user.set("password", hashedPasswordBase64);
        user.set("salt", salt);
        user.save();
        this.addOrUpdateCache(user);
    }

    private void addOrUpdateCache(User user) {
        Redis.use().del((Object)("user_" + user.getPKValue()));
        Redis.use().del((Object)("user_" + user.getStr("username")));
        Redis.use().del((Object)("user_" + user.getStr("email")));
        Redis.use().del((Object)("user_" + user.getStr("mobile")));
        Redis.use().set("user_" + user.getPKValue(), user);
        Redis.use().set("user_" + user.getStr("username"), user);
        Redis.use().set("user_" + user.getStr("email"), user);
        Redis.use().set("user_" + user.getStr("mobile"), user);
    }

    public void update(User user) {
        String password = user.getStr("password");
        if (password != null) {
            String userId = user.getStr("userid");
            User upUser = (User)User.dao.findFirst(this.getSql("domeke.core.user.selectById"), userId);
            if (!password.equals(upUser.get("password"))) {
                String userName = (String)user.get("username");
                if (userName == null) {
                    userName = (String)upUser.get("username");
                }
                String hashedPasswordBase64 = new Sha256Hash((Object)password).toHex();
                user.set("password", hashedPasswordBase64);
            } else {
                user.remove("password");
            }
        }
        user.update();
        this.addOrUpdateCache(user);
    }

    public String checkUserNameAndEmail(String userName, String email) {
        User checkName = (User)User.dao.findFirst(this.getSql("domeke.core.user.selectCountByName"), userName);
        User checkEmail = (User)User.dao.findFirst(this.getSql("domeke.core.user.selectCountByEmail"), email);
        if (checkName != null) {
            return "\u7528\u6237\u540d\u5df2\u5b58\u5728";
        }
        if (checkEmail != null) {
            return "\u90ae\u7bb1\u5df2\u5b58\u5728";
        }
        return null;
    }

    public User query(Object id) {
        return (User)User.dao.findById(id);
    }

    public List<User> queryAllUser() {
        return User.dao.find(this.getSql("domeke.core.user.queryAll"));
    }

    public List<User> queryByFilter(Map<String, Object> filter) {
        return User.dao.find(this.getSql("domeke.core.user.queryByFilter", filter));
    }

    public List<User> queryUserIdNameList() {
        return User.dao.find(this.getSql("domeke.core.user.queryUserIdNameMap"));
    }

    public Page<User> queryUserList(int pageNumber, Map<String, Object> filter) {
        return User.dao.queryUserList(pageNumber, filter);
    }

    public List<Company> queryCompanyList() {
        return Company.dao.queryCompanyCodedata();
    }

    @Override
    public void cacheAll() {
        logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aUser start");
        String sql = this.getSql("domeke.core.user.queryAll");
        List userList = User.dao.find(sql);
        for (User user : userList) {
            CacheKit.put("system", "user_" + user.getPKValue(), user);
            CacheKit.put("system", "user_" + user.getStr("username"), user);
            CacheKit.put("system", "user_" + user.getStr("email"), user);
            CacheKit.put("system", "user_" + user.getStr("mobile"), user);
            user = null;
        }
        logger.info("\u7f13\u5b58\u52a0\u8f7d\uff1aUser end, size = " + userList.size());
        userList = null;
    }

    @Override
    public void removeCache(String ids) {
        User user = (User)User.dao.findById((Object)ids);
        CacheKit.remove("system", "user_" + ids);
        CacheKit.remove("system", "user_" + user.getStr("username"));
        CacheKit.remove("system", "user_" + user.getStr("email"));
        CacheKit.remove("system", "user_" + user.getStr("mobile"));
    }

    public User getCache(String cacheName) {
        User user = (User)CacheKit.get("system", "user_" + cacheName);
        return user;
    }

    @Override
    public void removeCache() {
        CacheKit.remove("system", "user_");
    }
}

