/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.shiro;

import com.domeke.core.shiro.AbstractAuthzHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;

class RoleAuthzHandler
extends AbstractAuthzHandler {
    private final Annotation annotation;

    public RoleAuthzHandler(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public void assertAuthorized() throws AuthorizationException {
        RequiresRoles rrAnnotation = (RequiresRoles)this.annotation;
        String[] roles = rrAnnotation.value();
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
            return;
        }
        if (Logical.AND.equals((Object)rrAnnotation.logical())) {
            this.getSubject().checkRoles(Arrays.asList(roles));
            return;
        }
        if (Logical.OR.equals((Object)rrAnnotation.logical())) {
            boolean hasAtLeastOneRole = false;
            for (String role : roles) {
                if (!this.getSubject().hasRole(role)) continue;
                hasAtLeastOneRole = true;
            }
            if (!hasAtLeastOneRole) {
                this.getSubject().checkRole(roles[0]);
            }
        }
    }
}

