/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.shiro;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroMethod {
    private static final String NAMES_DELIMETER = ",";

    private ShiroMethod() {
    }

    protected static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static boolean hasRole(String roleName) {
        return ShiroMethod.getSubject() != null && roleName != null && roleName.length() > 0 && ShiroMethod.getSubject().hasRole(roleName);
    }

    public static boolean lacksRole(String roleName) {
        return !ShiroMethod.hasRole(roleName);
    }

    public static boolean hasAnyRoles(String roleNames) {
        boolean hasAnyRole = false;
        Subject subject = ShiroMethod.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (!subject.hasRole(role.trim())) continue;
                hasAnyRole = true;
                break;
            }
        }
        return hasAnyRole;
    }

    public static boolean hasAllRoles(String roleNames) {
        boolean hasAllRole = true;
        Subject subject = ShiroMethod.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (subject.hasRole(role.trim())) continue;
                hasAllRole = false;
                break;
            }
        }
        return hasAllRole;
    }

    public static boolean hasPermission(String permission) {
        return ShiroMethod.getSubject() != null && permission != null && permission.length() > 0 && ShiroMethod.getSubject().isPermitted(permission);
    }

    public static boolean lacksPermission(String permission) {
        return !ShiroMethod.hasPermission(permission);
    }

    public static boolean authenticated() {
        return ShiroMethod.getSubject() != null && ShiroMethod.getSubject().isAuthenticated();
    }

    public static boolean notAuthenticated() {
        return !ShiroMethod.authenticated();
    }

    public static boolean user() {
        return ShiroMethod.getSubject() != null && ShiroMethod.getSubject().getPrincipal() != null;
    }

    public static boolean guest() {
        return !ShiroMethod.user();
    }

    public String principal() {
        if (ShiroMethod.getSubject() != null) {
            Object principal = ShiroMethod.getSubject().getPrincipal();
            return principal.toString();
        }
        return "Guest";
    }
}

