/*
 * Decompiled with CFR 0.152.
 */
package com.domeke.core.tablebind;

import com.domeke.core.kit.ClassSearcher;
import com.domeke.core.model.BaseModel;
import com.domeke.core.tablebind.INameStyle;
import com.domeke.core.tablebind.SimpleNameStyles;
import com.domeke.core.tablebind.TableBind;
import com.google.common.collect.Lists;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.Model;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTableBindPlugin
extends ActiveRecordPlugin {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Class<? extends Model>> excludeClasses = Lists.newArrayList();
    private List<String> includeJars = Lists.newArrayList();
    private boolean autoScan = true;
    private boolean includeAllJarsInLib;
    private INameStyle nameStyle;

    public AutoTableBindPlugin(DataSource dataSource) {
        this(dataSource, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(DataSource dataSource, INameStyle nameStyle) {
        super(dataSource);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider) {
        this(dataSourceProvider, SimpleNameStyles.DEFAULT);
    }

    public AutoTableBindPlugin(IDataSourceProvider dataSourceProvider, INameStyle nameStyle) {
        super(dataSourceProvider);
        this.nameStyle = nameStyle;
    }

    public AutoTableBindPlugin addExcludeClasses(Class<? extends Model> ... clazzes) {
        for (Class<? extends Model> clazz : clazzes) {
            this.excludeClasses.add(clazz);
        }
        return this;
    }

    public AutoTableBindPlugin addExcludeClasses(List<Class<? extends Model>> clazzes) {
        if (clazzes != null) {
            this.excludeClasses.addAll(clazzes);
        }
        return this;
    }

    public AutoTableBindPlugin addJars(List<String> jars) {
        if (jars != null) {
            this.includeJars.addAll(jars);
        }
        return this;
    }

    public AutoTableBindPlugin addJars(String ... jars) {
        if (jars != null) {
            for (String jar : jars) {
                this.includeJars.add(jar);
            }
        }
        return this;
    }

    @Override
    public boolean start() {
        List modelClasses = ClassSearcher.of(BaseModel.class).injars(this.includeJars).includeAllJarsInLib(this.includeAllJarsInLib).search();
        TableBind tb = null;
        for (Class modelClass : modelClasses) {
            String tableName;
            if (this.excludeClasses.contains(modelClass)) continue;
            tb = modelClass.getAnnotation(TableBind.class);
            if (tb == null) {
                if (!this.autoScan) continue;
                tableName = this.nameStyle.name(modelClass.getSimpleName());
                this.addMapping(tableName, modelClass);
                this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
                continue;
            }
            tableName = tb.tableName();
            if (StrKit.isNotBlank(tb.pkName())) {
                this.addMapping(tableName, tb.pkName(), modelClass);
                this.log.debug("addMapping(" + tableName + ", " + tb.pkName() + "," + modelClass.getName() + ")");
                continue;
            }
            this.addMapping(tableName, modelClass);
            this.log.debug("addMapping(" + tableName + ", " + modelClass.getName() + ")");
        }
        return super.start();
    }

    @Override
    public boolean stop() {
        return super.stop();
    }

    public AutoTableBindPlugin autoScan(boolean autoScan) {
        this.autoScan = autoScan;
        return this;
    }

    public AutoTableBindPlugin includeAllJarsInLib(boolean includeAllJarsInLib) {
        this.includeAllJarsInLib = includeAllJarsInLib;
        return this;
    }
}

