/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Callback;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorBuilder;
import java.util.concurrent.ConcurrentHashMap;

public class Enhancer {
    private static final ConcurrentHashMap<String, Object> singleton = new ConcurrentHashMap();

    private Enhancer() {
    }

    public static <T> T enhance(Class<T> targetClass) {
        return (T)net.sf.cglib.proxy.Enhancer.create(targetClass, (net.sf.cglib.proxy.Callback)new Callback());
    }

    public static <T> T enhance(Class<T> targetClass, Interceptor ... injectInters) {
        return (T)net.sf.cglib.proxy.Enhancer.create(targetClass, (net.sf.cglib.proxy.Callback)new Callback(injectInters));
    }

    public static <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(targetClass, Enhancer.createInjectInters(injectIntersClasses));
    }

    public static <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass) {
        return Enhancer.enhance(targetClass, Enhancer.createInjectInters(injectIntersClass));
    }

    public static <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2) {
        return Enhancer.enhance(targetClass, Enhancer.createInjectInters(injectIntersClass1, injectIntersClass2));
    }

    public static <T> T enhance(Class<T> targetClass, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2, Class<? extends Interceptor> injectIntersClass3) {
        return Enhancer.enhance(targetClass, Enhancer.createInjectInters(injectIntersClass1, injectIntersClass2, injectIntersClass3));
    }

    public static <T> T getTarget(String singletonKey) {
        return (T)singleton.get(singletonKey);
    }

    public static <T> T enhance(String singletonKey, Class<T> targetClass) {
        Object target = singleton.get(singletonKey);
        if (target == null) {
            target = Enhancer.enhance(targetClass);
            singleton.put(singletonKey, target);
        }
        return (T)target;
    }

    public static <T> T enhance(String singletonKey, Class<T> targetClass, Interceptor ... injectInters) {
        Object target = singleton.get(singletonKey);
        if (target == null) {
            target = Enhancer.enhance(targetClass, injectInters);
            singleton.put(singletonKey, target);
        }
        return (T)target;
    }

    public static <T> T enhance(String singletonKey, Class<T> targetClass, Class<? extends Interceptor> ... injectIntersClasses) {
        Object target = singleton.get(singletonKey);
        if (target == null) {
            target = Enhancer.enhance(targetClass, injectIntersClasses);
            singleton.put(singletonKey, target);
        }
        return (T)target;
    }

    public static <T> T enhance(Object target) {
        return (T)net.sf.cglib.proxy.Enhancer.create(target.getClass(), (net.sf.cglib.proxy.Callback)new Callback(target, new Interceptor[0]));
    }

    public static <T> T enhance(Object target, Interceptor ... injectInters) {
        return (T)net.sf.cglib.proxy.Enhancer.create(target.getClass(), (net.sf.cglib.proxy.Callback)new Callback(target, injectInters));
    }

    public static <T> T enhance(Object target, Class<? extends Interceptor> ... injectIntersClasses) {
        return Enhancer.enhance(target, Enhancer.createInjectInters(injectIntersClasses));
    }

    public static <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass) {
        return Enhancer.enhance(target, Enhancer.createInjectInters(injectIntersClass));
    }

    public static <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2) {
        return Enhancer.enhance(target, Enhancer.createInjectInters(injectIntersClass1, injectIntersClass2));
    }

    public static <T> T enhance(Object target, Class<? extends Interceptor> injectIntersClass1, Class<? extends Interceptor> injectIntersClass2, Class<? extends Interceptor> injectIntersClass3) {
        return Enhancer.enhance(target, Enhancer.createInjectInters(injectIntersClass1, injectIntersClass2, injectIntersClass3));
    }

    public static <T> T enhance(String singletonKey, Object target) {
        Object result = singleton.get(singletonKey);
        if (result == null) {
            result = Enhancer.enhance(target);
            singleton.put(singletonKey, result);
        }
        return (T)result;
    }

    public static <T> T enhance(String singletonKey, Object target, Interceptor ... injectInters) {
        Object result = singleton.get(singletonKey);
        if (result == null) {
            result = Enhancer.enhance(target, injectInters);
            singleton.put(singletonKey, result);
        }
        return (T)result;
    }

    public static <T> T enhance(String singletonKey, Object target, Class<? extends Interceptor> ... injectIntersClasses) {
        Object result = singleton.get(singletonKey);
        if (result == null) {
            result = Enhancer.enhance(target, injectIntersClasses);
            singleton.put(singletonKey, result);
        }
        return (T)result;
    }

    private static Interceptor[] createInjectInters(Class<? extends Interceptor> ... injectInterClasses) {
        if (injectInterClasses == null || injectInterClasses.length == 0) {
            throw new IllegalArgumentException("injectInterClasses can be null or be blank array");
        }
        Interceptor[] result = new Interceptor[injectInterClasses.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = injectInterClasses[i].newInstance();
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addGlobalServiceInterceptor(Interceptor ... inters) {
        InterceptorBuilder.addGlobalServiceInterceptor(inters);
    }
}

