/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.aop.Interceptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class InterceptorBuilder {
    public static final Interceptor[] NULL_INTERS = new Interceptor[0];
    private static Interceptor[] globalInters = NULL_INTERS;
    private static Map<Class<? extends Interceptor>, Interceptor> intersMap = new HashMap<Class<? extends Interceptor>, Interceptor>();

    public static Interceptor[] build(Interceptor[] injectInters, Class<?> targetClass, Method method) {
        Interceptor[] methodInters = InterceptorBuilder.createInterceptors(method.getAnnotation(Before.class));
        Clear clear = method.getAnnotation(Clear.class);
        if (clear == null) {
            Interceptor[] classInters = InterceptorBuilder.createInterceptors(targetClass.getAnnotation(Before.class));
            Interceptor[] result = new Interceptor[globalInters.length + injectInters.length + classInters.length + methodInters.length];
            int index = 0;
            for (Interceptor inter : globalInters) {
                result[index++] = inter;
            }
            for (Interceptor inter : injectInters) {
                result[index++] = inter;
            }
            for (Interceptor inter : classInters) {
                result[index++] = inter;
            }
            for (Interceptor inter : methodInters) {
                result[index++] = inter;
            }
            return result;
        }
        Class<? extends Interceptor>[] clearInters = clear.value();
        if (clearInters.length == 0) {
            return methodInters;
        }
        Interceptor[] classInters = InterceptorBuilder.createInterceptors(targetClass.getAnnotation(Before.class));
        Interceptor[] temp = new Interceptor[globalInters.length + injectInters.length + classInters.length];
        int index = 0;
        for (Interceptor inter : globalInters) {
            temp[index++] = inter;
        }
        for (Interceptor inter : injectInters) {
            temp[index++] = inter;
        }
        for (Interceptor inter : classInters) {
            temp[index++] = inter;
        }
        int removeCount = 0;
        block7: for (int i = 0; i < temp.length; ++i) {
            Class<? extends Interceptor>[] classArray = clearInters;
            int n = classArray.length;
            for (int j = 0; j < n; ++j) {
                Class<? extends Interceptor> ci = classArray[j];
                if (temp[i].getClass() != ci) continue;
                temp[i] = null;
                ++removeCount;
                continue block7;
            }
        }
        Interceptor[] result = new Interceptor[temp.length + methodInters.length - removeCount];
        index = 0;
        for (Interceptor inter : temp) {
            if (inter == null) continue;
            result[index++] = inter;
        }
        for (Interceptor inter : methodInters) {
            result[index++] = inter;
        }
        return result;
    }

    private static Interceptor[] createInterceptors(Before beforeAnnotation) {
        if (beforeAnnotation == null) {
            return NULL_INTERS;
        }
        Class<? extends Interceptor>[] interceptorClasses = beforeAnnotation.value();
        if (interceptorClasses.length == 0) {
            return NULL_INTERS;
        }
        Interceptor[] result = new Interceptor[interceptorClasses.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = intersMap.get(interceptorClasses[i]);
                if (result[i] != null) continue;
                result[i] = interceptorClasses[i].newInstance();
                intersMap.put(interceptorClasses[i], result[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static synchronized void addGlobalServiceInterceptor(Interceptor ... inters) {
        if (inters == null) {
            throw new IllegalArgumentException("interceptors can not be null.");
        }
        for (Interceptor inter : inters) {
            if (!intersMap.containsKey(inter.getClass())) continue;
            throw new IllegalArgumentException("interceptor already exists, interceptor must be singlton, do not create more then one instance of the same Interceptor Class.");
        }
        for (Interceptor inter : inters) {
            intersMap.put(inter.getClass(), inter);
        }
        Interceptor[] temp = new Interceptor[globalInters.length + inters.length];
        System.arraycopy(globalInters, 0, temp, 0, globalInters.length);
        System.arraycopy(inters, 0, temp, globalInters.length, inters.length);
        globalInters = temp;
    }
}

