/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.kit.StrKit;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionException
extends RuntimeException {
    private static final long serialVersionUID = 1998063243843477017L;
    private static final Logger log = LoggerFactory.getLogger(ActionException.class);
    private int errorCode;
    private Render errorRender;

    public ActionException(final int errorCode, final Render errorRender) {
        if (errorRender == null) {
            throw new IllegalArgumentException("The parameter errorRender can not be null.");
        }
        this.errorCode = errorCode;
        this.errorRender = errorRender instanceof ErrorRender ? errorRender : new Render(){

            @Override
            public Render setContext(HttpServletRequest req, HttpServletResponse res, String viewPath) {
                errorRender.setContext(req, res, viewPath);
                res.setStatus(errorCode);
                return this;
            }

            @Override
            public void render() {
                errorRender.render();
            }
        };
    }

    public ActionException(int errorCode, String errorView) {
        if (StrKit.isBlank(errorView)) {
            throw new IllegalArgumentException("The parameter errorView can not be blank.");
        }
        this.errorCode = errorCode;
        this.errorRender = RenderFactory.me().getErrorRender(errorCode, errorView);
    }

    public ActionException(int errorCode, Render errorRender, String errorMessage) {
        this(errorCode, errorRender);
        log.warn(errorMessage);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Render getErrorRender() {
        return this.errorRender;
    }
}

