/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.config.Constants;
import com.jfinal.config.JFinalConfig;
import com.jfinal.core.Action;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.ActionMapping;
import com.jfinal.core.Config;
import com.jfinal.handler.Handler;
import com.jfinal.handler.HandlerFactory;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.render.RenderFactory;
import com.jfinal.server.IServer;
import com.jfinal.server.ServerFactory;
import com.jfinal.token.ITokenCache;
import com.jfinal.token.TokenManager;
import com.jfinal.upload.OreillyCos;
import java.util.List;
import javax.servlet.ServletContext;

public final class JFinal {
    private Constants constants;
    private ActionMapping actionMapping;
    private Handler handler;
    private ServletContext servletContext;
    private static IServer server;
    private String contextPath = "";
    private static final JFinal me;

    Handler getHandler() {
        return this.handler;
    }

    private JFinal() {
    }

    public static JFinal me() {
        return me;
    }

    boolean init(JFinalConfig jfinalConfig, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.contextPath = servletContext.getContextPath();
        this.initPathUtil();
        Config.configJFinal(jfinalConfig);
        this.constants = Config.getConstants();
        this.initActionMapping();
        this.initHandler();
        this.initRender();
        this.initOreillyCos();
        this.initTokenManager();
        return true;
    }

    private void initTokenManager() {
        ITokenCache tokenCache = this.constants.getTokenCache();
        if (tokenCache != null) {
            TokenManager.init(tokenCache);
        }
    }

    private void initHandler() {
        ActionHandler actionHandler = new ActionHandler(this.actionMapping, this.constants);
        this.handler = HandlerFactory.getHandler(Config.getHandlers().getHandlerList(), actionHandler);
    }

    private void initOreillyCos() {
        OreillyCos.init(this.constants.getUploadedFileSaveDirectory(), this.constants.getMaxPostSize(), this.constants.getEncoding());
    }

    private void initPathUtil() {
        String path = this.servletContext.getRealPath("/");
        PathKit.setWebRootPath(path);
    }

    private void initRender() {
        RenderFactory renderFactory = RenderFactory.me();
        renderFactory.init(this.constants, this.servletContext);
    }

    private void initActionMapping() {
        this.actionMapping = new ActionMapping(Config.getRoutes(), Config.getInterceptors());
        this.actionMapping.buildActionMapping();
    }

    void stopPlugins() {
        List<IPlugin> plugins = Config.getPlugins().getPluginList();
        if (plugins != null) {
            for (int i = plugins.size() - 1; i >= 0; --i) {
                boolean success = false;
                try {
                    success = plugins.get(i).stop();
                }
                catch (Exception e) {
                    success = false;
                    e.printStackTrace();
                }
                if (success) continue;
                System.err.println("Plugin stop error: " + plugins.get(i).getClass().getName());
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public static void start() {
        server = ServerFactory.getServer();
        server.start();
    }

    public static void start(String webAppDir, int port, String context, int scanIntervalSeconds) {
        server = ServerFactory.getServer(webAppDir, port, context, scanIntervalSeconds);
        server.start();
    }

    public static void stop() {
        server.stop();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            server = ServerFactory.getServer();
            server.start();
        } else {
            String webAppDir = args[0];
            int port = Integer.parseInt(args[1]);
            String context = args[2];
            int scanIntervalSeconds = Integer.parseInt(args[3]);
            server = ServerFactory.getServer(webAppDir, port, context, scanIntervalSeconds);
            server.start();
        }
    }

    public List<String> getAllActionKeys() {
        return this.actionMapping.getAllActionKeys();
    }

    public Constants getConstants() {
        return Config.getConstants();
    }

    public Action getAction(String url, String[] urlPara) {
        return this.actionMapping.getAction(url, urlPara);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    static {
        me = new JFinal();
    }
}

