/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.handler;

import com.jfinal.handler.Handler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNameRedirect301Handler
extends Handler {
    private String originalServerName;
    private String targetServerName;
    private int serverNameLength;

    public ServerNameRedirect301Handler(String originalServerName, String targetServerName) {
        this.originalServerName = originalServerName;
        this.targetServerName = targetServerName;
        this.format();
        this.serverNameLength = this.originalServerName.length();
    }

    private final void format() {
        if (this.originalServerName.endsWith("/")) {
            this.originalServerName = this.originalServerName.substring(0, this.originalServerName.length() - 1);
        }
        if (this.targetServerName.endsWith("/")) {
            this.targetServerName = this.targetServerName.substring(0, this.targetServerName.length() - 1);
        }
        if (this.originalServerName.indexOf("://") == -1) {
            this.originalServerName = "http://" + this.originalServerName;
        }
        if (this.targetServerName.indexOf("://") == -1) {
            this.targetServerName = "http://" + this.targetServerName;
        }
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        String url = request.getRequestURL().toString();
        if (url.startsWith(this.originalServerName)) {
            isHandled[0] = true;
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            url = this.targetServerName + url.substring(this.serverNameLength) + queryString;
            response.setStatus(301);
            response.setHeader("Location", url);
            response.setHeader("Connection", "close");
        } else {
            this.nextHandler.handle(target, request, response, isHandled);
        }
    }
}

