/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.jfinal.kit.StrKit;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeKit {
    public static String dateFormat = "yyyy-MM-dd";
    public static String timeFormat = "yyyy-MM-dd HH:mm:ss";
    private static LocalDate now = LocalDate.now();
    private static Logger logger = LoggerFactory.getLogger(DateTimeKit.class);

    public static void setDateFromat(String dateFormat) {
        if (StrKit.isBlank(dateFormat)) {
            throw new IllegalArgumentException("dateFormat can not be blank.");
        }
        DateTimeKit.dateFormat = dateFormat;
    }

    public static void setTimeFromat(String timeFormat) {
        if (StrKit.isBlank(timeFormat)) {
            throw new IllegalArgumentException("timeFormat can not be blank.");
        }
        DateTimeKit.timeFormat = timeFormat;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static String format(String date, String parsePattern, String returnPattern) {
        return DateTimeKit.format(DateTimeKit.parse(date, parsePattern), returnPattern);
    }

    public static Date parse(String date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            logger.error("parse\u5f02\u5e38\uff1adate\u503c" + date + "\uff0cpattern\u503c" + pattern);
            return null;
        }
    }

    public static Date parse(String dateStr) {
        Date date = null;
        try {
            date = DateFormat.getDateTimeInstance().parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("parse\u5f02\u5e38\uff1adate\u503c" + date);
            return null;
        }
        return date;
    }

    public static LocalDate getLastWeekStart() {
        return DateTimeKit.firstDayOfWeek(now.minusWeeks(1L));
    }

    public static LocalDate getLastWeekEnd() {
        return DateTimeKit.lastDayOfWeek(now.minusWeeks(1L));
    }

    public static LocalDate getCurrernWeekStart() {
        return DateTimeKit.firstDayOfWeek(now);
    }

    public static LocalDate getCurrernWeekEnd() {
        return DateTimeKit.lastDayOfWeek(now);
    }

    public static LocalDate lastDayOfWeek(LocalDate date) {
        return date.with(DayOfWeek.SUNDAY);
    }

    public static LocalDate firstDayOfWeek(LocalDate date) {
        return date.with(DayOfWeek.MONDAY);
    }

    public static boolean isBetween(LocalDate now, LocalDate start, LocalDate end) {
        if (now.isEqual(start)) {
            return true;
        }
        if (now.isEqual(end)) {
            return true;
        }
        return now.isAfter(end) && now.isBefore(start);
    }

    public static Date getDate() {
        return new Date();
    }

    public static int getDateDaySpace(Date start, Date end) {
        int day = DateTimeKit.getDateHourSpace(start, end) / 24;
        return day;
    }

    public static int getDateHourSpace(Date start, Date end) {
        int hour = (int)((start.getTime() - end.getTime()) / 3600L / 1000L);
        return hour;
    }

    public static long getDateTime() {
        return new Date().getTime();
    }

    public static Timestamp getSqlTimestamp(Date date) {
        if (null == date) {
            date = new Date();
        }
        return DateTimeKit.getSqlTimestamp(date.getTime());
    }

    public static Timestamp getSqlTimestamp(long time) {
        return new Timestamp(time);
    }
}

