/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import com.jfinal.i18n.Res;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class I18n {
    static String defaultBaseName = "i18n";
    static String defaultLocale = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
    private static final Map<String, Res> resMap = new HashMap<String, Res>();

    private I18n() {
    }

    public static void setDefaultBaseName(String defaultBaseName) {
        if (StrKit.isBlank(defaultBaseName)) {
            throw new IllegalArgumentException("defaultBaseName can not be blank.");
        }
        I18n.defaultBaseName = defaultBaseName;
    }

    public static void setDefaultLocale(String defaultLocale) {
        if (StrKit.isBlank(defaultLocale)) {
            throw new IllegalArgumentException("defaultLocale can not be blank.");
        }
        I18n.defaultLocale = defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Res use(String baseName, String locale) {
        String resKey = baseName + locale;
        Res res = resMap.get(resKey);
        if (res == null) {
            Map<String, Res> map = resMap;
            synchronized (map) {
                res = resMap.get(resKey);
                if (res == null) {
                    res = new Res(baseName, locale);
                    resMap.put(resKey, res);
                }
            }
        }
        return res;
    }

    public static Res use(String baseName, Locale locale) {
        return I18n.use(baseName, locale.getLanguage() + "_" + locale.getCountry());
    }

    public static Res use(String locale) {
        return I18n.use(defaultBaseName, locale);
    }

    public static Res use() {
        return I18n.use(defaultBaseName, defaultLocale);
    }
}

