/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.i18n.I18n;
import com.jfinal.i18n.Res;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;

public class I18nInterceptor
implements Interceptor {
    private String localePara = "_locale";
    private String resName = "_res";
    private boolean isSwitchView = false;

    public I18nInterceptor() {
    }

    public I18nInterceptor(String localePara, String resName) {
        if (StrKit.isBlank(localePara)) {
            throw new IllegalArgumentException("localePara can not be blank.");
        }
        if (StrKit.isBlank(resName)) {
            throw new IllegalArgumentException("resName can not be blank.");
        }
        this.localePara = localePara;
        this.resName = resName;
    }

    public I18nInterceptor(String localePara, String resName, boolean isSwitchView) {
        this(localePara, resName);
        this.isSwitchView = isSwitchView;
    }

    protected String getLocalePara() {
        return this.localePara;
    }

    protected String getResName() {
        return this.resName;
    }

    protected String getBaseName() {
        return I18n.defaultBaseName;
    }

    @Override
    public void intercept(Invocation inv) {
        inv.invoke();
        Controller c = inv.getController();
        String localePara = this.getLocalePara();
        String locale = c.getPara(localePara);
        if (StrKit.isNotBlank(locale)) {
            c.setCookie(localePara, locale, 999999999);
        } else {
            locale = c.getCookie(localePara);
            if (StrKit.isBlank(locale)) {
                locale = I18n.defaultLocale;
            }
        }
        if (this.isSwitchView) {
            this.switchView(locale, c);
        } else {
            Res res = I18n.use(this.getBaseName(), locale);
            c.setAttr(this.getResName(), res);
        }
    }

    public void switchView(String locale, Controller c) {
        String view;
        Render render = c.getRender();
        if (render != null && (view = render.getView()) != null) {
            view = view.startsWith("/") ? "/" + locale + view : locale + "/" + view;
            render.setView(view);
        }
    }
}

