/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import java.security.MessageDigest;
import java.security.SecureRandom;

public class HashKit {
    private static SecureRandom random = new SecureRandom();

    public static String md5(String srcStr) {
        return HashKit.hash("MD5", srcStr);
    }

    public static String sha1(String srcStr) {
        return HashKit.hash("SHA-1", srcStr);
    }

    public static String sha256(String srcStr) {
        return HashKit.hash("SHA-256", srcStr);
    }

    public static String sha384(String srcStr) {
        return HashKit.hash("SHA-384", srcStr);
    }

    public static String sha512(String srcStr) {
        return HashKit.hash("SHA-512", srcStr);
    }

    public static String hash(String algorithm, String srcStr) {
        try {
            byte[] bytes;
            StringBuilder result = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            for (byte b : bytes = md.digest(srcStr.getBytes("utf-8"))) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    result.append("0");
                }
                result.append(hex);
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                result.append("0");
            }
            result.append(hex);
        }
        return result.toString();
    }

    public static String generateSalt(int numberOfBytes) {
        byte[] salt = new byte[numberOfBytes];
        random.nextBytes(salt);
        return HashKit.toHex(salt);
    }
}

