/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.Prop;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PropKit {
    private static Prop prop = null;
    private static final Map<String, Prop> map = new HashMap<String, Prop>();

    private PropKit() {
    }

    public static Prop use(String fileName) {
        return PropKit.use(fileName, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop use(String fileName, String encoding) {
        Prop result = map.get(fileName);
        if (result == null) {
            Map<String, Prop> map = PropKit.map;
            synchronized (map) {
                result = PropKit.map.get(fileName);
                if (result == null) {
                    result = new Prop(fileName, encoding);
                    PropKit.map.put(fileName, result);
                    if (prop == null) {
                        prop = result;
                    }
                }
            }
        }
        return result;
    }

    public static Prop use(File file) {
        return PropKit.use(file, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop use(File file, String encoding) {
        Prop result = map.get(file.getName());
        if (result == null) {
            Map<String, Prop> map = PropKit.map;
            synchronized (map) {
                result = PropKit.map.get(file.getName());
                if (result == null) {
                    result = new Prop(file, encoding);
                    PropKit.map.put(file.getName(), result);
                    if (prop == null) {
                        prop = result;
                    }
                }
            }
        }
        return result;
    }

    public static Prop useless(String fileName) {
        Prop previous = map.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        map.clear();
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking PropKit.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return PropKit.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return PropKit.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return PropKit.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return PropKit.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return PropKit.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return PropKit.getProp().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return PropKit.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return PropKit.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return PropKit.getProp().containsKey(key);
    }
}

