/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.domeke.core.db.sql.SqlKit;
import com.domeke.core.model.User;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class StrKit
extends StringUtils {
    public static final String regExp_integer_1 = "^\\d+$";
    public static final String regExp_integer_2 = "^[0-9]*[1-9][0-9]*$";
    public static final String regExp_integer_3 = "^((-\\d+) ?(0+))$";
    public static final String regExp_integer_4 = "^-[0-9]*[1-9][0-9]*$";
    public static final String regExp_integer_5 = "^-?\\d+$";
    public static final String regExp_float_1 = "^\\d+(\\.\\d+)?$";
    public static final String regExp_float_2 = "^(([0-9]+\\.[0-9]*[1-9][0-9]*) ?([0-9]*[1-9][0-9]*\\.[0-9]+) ?([0-9]*[1-9][0-9]*))$";
    public static final String regExp_float_3 = "^((-\\d+(\\.\\d+)?) ?(0+(\\.0+)?))$";
    public static final String regExp_float_4 = "^(-(([0-9]+\\.[0-9]*[1-9][0-9]*) ?([0-9]*[1-9][0-9]*\\.[0-9]+) ?([0-9]*[1-9][0-9]*)))$";
    public static final String regExp_float_5 = "^(-?\\d+)(\\.\\d+)?$";
    public static final String regExp_letter_1 = "^[A-Za-z]+$";
    public static final String regExp_letter_2 = "^[A-Z]+$";
    public static final String regExp_letter_3 = "^[a-z]+$";
    public static final String regExp_letter_4 = "^[A-Za-z0-9]+$";
    public static final String regExp_letter_5 = "^\\w+$";
    public static final String regExp_email = "^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$";
    public static final String regExp_url_1 = "^[a-zA-z]+://(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?$";
    public static final String regExp_url_2 = "[a-zA-z]+://[^\\s]*";
    public static final String regExp_chinese_1 = "[\\u4e00-\\u9fa5]";
    public static final String regExp_chinese_2 = "[^\\x00-\\xff]";
    public static final String regExp_line = "\\n[\\s ? ]*\\r";
    public static final String regExp_html_1 = "/ <(.*)>.* <\\/\\1> ? <(.*) \\/>/";
    public static final String regExp_startEndEmpty = "(^\\s*) ?(\\s*$)";
    public static final String regExp_accountNumber = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    public static final String regExp_telephone = "\\d{3}-\\d{8} ?\\d{4}-\\d{7}";
    public static final String regExp_qq = "[1-9][0-9]{4,}";
    public static final String regExp_postbody = "[1-9]\\d{5}(?!\\d)";
    public static final String regExp_idCard = "\\d{15} ?\\d{18}";
    public static final String regExp_ip = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    public static final String ENCODING = "UTF-8";
    public static final Pattern referer_pattern = Pattern.compile("@([^@^\\s^:]{1,})([\\s\\:\\,\\;]{0,1})");

    public static String encode(String data) throws Exception {
        byte[] b = Base64.encodeBase64URLSafe((byte[])data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }

    public static String decode(String data) throws Exception {
        byte[] b = Base64.decodeBase64((byte[])data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }

    public static String urlEncode(String source) {
        String result = source;
        try {
            result = URLEncoder.encode(source, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getFileExt(String contentType) {
        String fileExt = "";
        if ("image/jpeg".equals(contentType)) {
            fileExt = ".jpg";
        } else if ("audio/mpeg".equals(contentType)) {
            fileExt = ".mp3";
        } else if ("audio/amr".equals(contentType)) {
            fileExt = ".amr";
        } else if ("video/mp4".equals(contentType)) {
            fileExt = ".mp4";
        } else if ("video/mpeg4".equals(contentType)) {
            fileExt = ".mp4";
        }
        return fileExt;
    }

    public static String beanName(Object bean) {
        String fullClassName = bean.getClass().getName();
        String classNameTemp = fullClassName.substring(fullClassName.lastIndexOf(".") + 1, fullClassName.length());
        return classNameTemp.substring(0, 1) + classNameTemp.substring(1);
    }

    public static String userLinks(String contents, List<String> userReferers) {
        StringBuilder html = new StringBuilder();
        int lastIdx = 0;
        Matcher matchr = referer_pattern.matcher(contents);
        while (matchr.find()) {
            String origion_str = matchr.group();
            String userName = origion_str.substring(1, origion_str.length()).trim();
            html.append(contents.substring(lastIdx, matchr.start()));
            User user = null;
            Object userObj = User.dao.get(userName);
            if (null != userObj) {
                user = (User)userObj;
            } else {
                HashMap param = Maps.newHashMap();
                param.put("column", "username");
                String sql = SqlKit.getSql("platform.user.column", param);
                List userList = User.dao.find(sql, userName);
                if (userList.size() == 1) {
                    user = (User)userList.get(0);
                }
            }
            if (user != null) {
                html.append("<a href='http://www.xx.com/" + user.getStr("username") + "' class='referer' target='_blank'>@");
                html.append(userName.trim());
                html.append("</a> ");
                if (userReferers != null && !userReferers.contains(user.getPKValue())) {
                    userReferers.add(user.getPKValue());
                }
            } else {
                html.append(origion_str);
            }
            lastIdx = matchr.end();
        }
        html.append(contents.substring(lastIdx));
        return html.toString();
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StrKit.isBlank(str);
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(locale);
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(locale);
    }

    public static String replace(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + with.length());
        do {
            buf.append(s.substring(c, i));
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static Timestamp toTimestamp(String format, String dateStr) {
        if (StrKit.isBlank(format) || StrKit.isBlank(dateStr)) {
            return null;
        }
        Timestamp date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = new Timestamp(sdf.parse(dateStr).getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String randomNumber(int len) {
        String[] group = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            Random random = new Random();
            sb.append(group[random.nextInt(10)]);
        }
        return sb.toString();
    }
}

