/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.google.common.collect.Maps;
import com.jfinal.render.FreeMarkerRender;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;

public class XmlRender
extends FreeMarkerRender {
    private static final String contentType = "text/xml; charset=" + XmlRender.getEncoding();

    public XmlRender(String view) {
        super(view);
    }

    @Override
    public void render() {
        this.response.setContentType(contentType);
        HashMap root = Maps.newHashMap();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            root.put(attrName, this.request.getAttribute(attrName));
        }
        try (PrintWriter writer = null;){
            Template template = XmlRender.getConfiguration().getTemplate(this.view);
            writer = this.response.getWriter();
            template.process((Object)root, (Writer)writer);
        }
    }
}

