/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.token;

import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import com.jfinal.token.ITokenCache;
import com.jfinal.token.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class TokenManager {
    private static ITokenCache tokenCache;
    private static Random random;

    private TokenManager() {
    }

    public static void init(ITokenCache tokenCache) {
        if (tokenCache == null) {
            return;
        }
        TokenManager.tokenCache = tokenCache;
        long halfTimeOut = 150000L;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                TokenManager.removeTimeOutToken();
            }
        }, halfTimeOut, halfTimeOut);
    }

    public static void createToken(Controller controller, String tokenName, int secondsOfTimeOut) {
        if (tokenCache == null) {
            String tokenId = String.valueOf(random.nextLong());
            controller.setAttr(tokenName, tokenId);
            controller.setSessionAttr(tokenName, tokenId);
            TokenManager.createTokenHiddenField(controller, tokenName, tokenId);
        } else {
            TokenManager.createTokenUseTokenIdGenerator(controller, tokenName, secondsOfTimeOut);
        }
    }

    private static void createTokenHiddenField(Controller controller, String tokenName, String tokenId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<input type='hidden' name='").append(tokenName).append("' value='" + tokenId).append("' />");
        controller.setAttr("token", sb.toString());
    }

    private static void createTokenUseTokenIdGenerator(Controller controller, String tokenName, int secondsOfTimeOut) {
        if (secondsOfTimeOut < 300) {
            secondsOfTimeOut = 300;
        }
        String tokenId = null;
        Token token = null;
        int safeCounter = 8;
        do {
            if (safeCounter-- == 0) {
                throw new RuntimeException("Can not create tokenId.");
            }
            tokenId = String.valueOf(random.nextLong());
            token = new Token(tokenId, System.currentTimeMillis() + (long)(secondsOfTimeOut * 1000));
        } while (tokenId == null || tokenCache.contains(token));
        controller.setAttr(tokenName, tokenId);
        tokenCache.put(token);
        TokenManager.createTokenHiddenField(controller, tokenName, tokenId);
    }

    public static synchronized boolean validateToken(Controller controller, String tokenName) {
        String clientTokenId = controller.getPara(tokenName);
        if (tokenCache == null) {
            String serverTokenId = (String)controller.getSessionAttr(tokenName);
            controller.removeSessionAttr(tokenName);
            return StrKit.isNotBlank(clientTokenId) && clientTokenId.equals(serverTokenId);
        }
        Token token = new Token(clientTokenId);
        boolean result = tokenCache.contains(token);
        tokenCache.remove(token);
        return result;
    }

    private static void removeTimeOutToken() {
        List<Token> tokenInCache = tokenCache.getAll();
        if (tokenInCache == null) {
            return;
        }
        ArrayList<Token> timeOutTokens = new ArrayList<Token>();
        long currentTime = System.currentTimeMillis();
        for (Token token : tokenInCache) {
            if (token.getExpirationTime() > currentTime) continue;
            timeOutTokens.add(token);
        }
        for (Token token : timeOutTokens) {
            tokenCache.remove(token);
        }
    }

    static {
        random = new Random();
    }
}

