/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.annotation;

import dorkbox.annotation.Builder;
import dorkbox.annotation.ClassFileBuffer;
import dorkbox.annotation.ClassFileIterator;
import dorkbox.annotation.ClassIterator;
import dorkbox.annotation.Cursor;
import dorkbox.annotation.CustomClassloaderIterator;
import dorkbox.annotation.Reporter;
import dorkbox.annotation.ReporterFunction;
import java.io.DataInput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationDetector
implements Builder,
Cursor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationDetector.class);
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int CP_METHOD_HANDLE = 15;
    private static final int CP_METHOD_TYPE = 16;
    private static final int CP_INVOKE_DYNAMIC = 18;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int ARRAY = 91;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private final ClassLoader loader;
    private final ClassFileBuffer cpBuffer = new ClassFileBuffer();
    private final ClassIterator cfIterator;
    private final Set<ElementType> elementTypes = EnumSet.of(ElementType.TYPE);
    private Object[] constantPool;
    private Map<String, Class<? extends Annotation>> annotations;
    private FilenameFilter filter;
    private Reporter reporter;
    private Class<? extends Annotation> annotationType;
    private String typeName;
    private String memberName;
    private ElementType elementType;
    private String methodDescriptor;

    private AnnotationDetector(ClassLoader loader, File[] filesOrDirectories, ClassIterator iterator, String[] pkgNameFilter) {
        this.loader = loader;
        if (iterator == null) {
            this.cfIterator = new ClassFileIterator(filesOrDirectories, pkgNameFilter);
            if (filesOrDirectories.length == 0) {
                LOG.warn("No files or directories to scan!");
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Files and root directories scanned:\n{}", (Object)Arrays.toString(filesOrDirectories).replace(", ", "\n"));
            }
        } else {
            this.cfIterator = iterator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Class Files from the custom classfileiterator scanned.");
            }
        }
    }

    public static String getVersion() {
        return "2.13";
    }

    public static Builder scanClassPath(String ... packageNames) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return AnnotationDetector.scanClassPath(loader, packageNames);
    }

    public static Builder scanClassPath(ClassLoader loader, String ... packageNames) throws IOException {
        String[] pkgNameFilter;
        boolean isCustomLoader;
        boolean bl = isCustomLoader = "dorkbox.classloader.ClassLoader" == loader.getClass().getName();
        if (isCustomLoader) {
            ArrayList<URL> fileNames;
            String[] pkgNameFilter2;
            if (packageNames.length == 0) {
                pkgNameFilter2 = null;
                List<String> asList = Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator));
                fileNames = new ArrayList<URL>(asList.size());
                for (String s : asList) {
                    File file = new File(s);
                    fileNames.add(file.toURI().toURL());
                }
            } else {
                pkgNameFilter2 = new String[packageNames.length];
                for (int i = 0; i < pkgNameFilter2.length; ++i) {
                    pkgNameFilter2[i] = packageNames[i].replace('.', '/');
                    if (pkgNameFilter2[i].endsWith("/")) continue;
                    pkgNameFilter2[i] = pkgNameFilter2[i].concat("/");
                }
                fileNames = new ArrayList();
                for (String packageName : pkgNameFilter2) {
                    Enumeration<URL> resourceEnum = loader.getResources(packageName);
                    while (resourceEnum.hasMoreElements()) {
                        URL url = resourceEnum.nextElement();
                        fileNames.add(url);
                    }
                }
            }
            return new AnnotationDetector(loader, null, new CustomClassloaderIterator(fileNames, packageNames), pkgNameFilter2);
        }
        HashSet<File> files = new HashSet<File>();
        if (packageNames.length == 0) {
            String[] fileNames;
            pkgNameFilter = null;
            for (String fileName : fileNames = System.getProperty("java.class.path").split(File.pathSeparator)) {
                files.add(new File(fileName));
            }
        } else {
            pkgNameFilter = new String[packageNames.length];
            for (int i = 0; i < pkgNameFilter.length; ++i) {
                pkgNameFilter[i] = packageNames[i].replace('.', '/');
                if (pkgNameFilter[i].endsWith("/")) continue;
                pkgNameFilter[i] = pkgNameFilter[i].concat("/");
            }
            for (String packageName : pkgNameFilter) {
                AnnotationDetector.addFiles(loader, packageName, files);
            }
        }
        return new AnnotationDetector(loader, files.toArray(new File[files.size()]), null, pkgNameFilter);
    }

    public static Builder scan(ClassLoader loader, ClassIterator iterator) {
        return new AnnotationDetector(loader, null, iterator, null);
    }

    public static Builder scanFiles(ClassLoader loader, File ... filesOrDirectories) {
        return new AnnotationDetector(loader, filesOrDirectories, null, null);
    }

    public static Builder scanFiles(File ... filesOrDirectories) {
        return new AnnotationDetector(Thread.currentThread().getContextClassLoader(), filesOrDirectories, null, null);
    }

    @Override
    public Builder forAnnotations(Class<? extends Annotation> annotation) {
        this.annotations = new HashMap<String, Class<? extends Annotation>>(1);
        this.annotations.put("L" + annotation.getName().replace('.', '/') + ";", annotation);
        return this;
    }

    @Override
    public Builder forAnnotations(Class<? extends Annotation> ... annotations) {
        this.annotations = new HashMap<String, Class<? extends Annotation>>(annotations.length);
        for (Class<? extends Annotation> annotation : annotations) {
            this.annotations.put("L" + annotation.getName().replace('.', '/') + ";", annotation);
        }
        return this;
    }

    @Override
    public Builder on(ElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("At least one Element Type must be specified");
        }
        this.elementTypes.clear();
        switch (type) {
            case TYPE: 
            case CONSTRUCTOR: 
            case METHOD: 
            case FIELD: {
                this.elementTypes.add(type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported: " + (Object)((Object)type));
            }
        }
        return this;
    }

    @Override
    public Builder on(ElementType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("At least one Element Type must be specified");
        }
        this.elementTypes.clear();
        block3: for (ElementType t : types) {
            switch (t) {
                case TYPE: 
                case CONSTRUCTOR: 
                case METHOD: 
                case FIELD: {
                    this.elementTypes.add(t);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported: " + (Object)((Object)t));
                }
            }
        }
        return this;
    }

    @Override
    public Builder filter(FilenameFilter filter) {
        if (filter == null) {
            throw new NullPointerException("'filter' may not be null");
        }
        this.filter = filter;
        return this;
    }

    @Override
    public void report(Reporter reporter) throws IOException {
        this.reporter = reporter;
        this.detect(this.cfIterator);
    }

    @Override
    public <T> List<T> collect(final ReporterFunction<T> reporter) throws IOException {
        final ArrayList list = new ArrayList();
        this.reporter = new Reporter(){

            @Override
            public void report(Cursor cursor) {
                list.add(reporter.report(cursor));
            }
        };
        this.detect(this.cfIterator);
        return list;
    }

    @Override
    public String getTypeName() {
        return this.typeName.replace('/', '.');
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getMemberName() {
        return this.memberName;
    }

    @Override
    public Class<?> getType() {
        return AnnotationDetector.loadClass(this.loader, this.getTypeName());
    }

    @Override
    public Field getField() {
        if (this.elementType != ElementType.FIELD) {
            throw new IllegalStateException("Illegal to call getField() when " + (Object)((Object)this.elementType) + " is reported");
        }
        try {
            return this.getType().getDeclaredField(this.memberName);
        }
        catch (NoSuchFieldException ex) {
            throw AnnotationDetector.assertionError("Cannot find Field '%s' for type %s", this.memberName, this.getTypeName());
        }
    }

    @Override
    public Constructor<?> getConstructor() {
        if (this.elementType != ElementType.CONSTRUCTOR) {
            throw new IllegalStateException("Illegal to call getMethod() when " + (Object)((Object)this.elementType) + " is reported");
        }
        try {
            Class<?>[] parameterTypes = this.parseArguments(this.methodDescriptor);
            return this.getType().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw AnnotationDetector.assertionError("Cannot find Contructor '%s(...)' for type %s", this.memberName, this.getTypeName());
        }
    }

    @Override
    public Method getMethod() {
        if (this.elementType != ElementType.METHOD) {
            throw new IllegalStateException("Illegal to call getMethod() when " + (Object)((Object)this.elementType) + " is reported");
        }
        try {
            Class<?>[] parameterTypes = this.parseArguments(this.methodDescriptor);
            return this.getType().getDeclaredMethod(this.memberName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw AnnotationDetector.assertionError("Cannot find Method '%s(...)' for type %s", this.memberName, this.getTypeName());
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        AnnotatedElement ae;
        if (!annotationClass.equals(this.annotationType)) {
            throw new IllegalStateException("Illegal to call getAnnotation() when " + this.annotationType.getName() + " is reported");
        }
        switch (this.elementType) {
            case TYPE: {
                ae = this.getType();
                break;
            }
            case FIELD: {
                ae = this.getField();
                break;
            }
            case METHOD: {
                ae = this.getMethod();
                break;
            }
            default: {
                throw new AssertionError((Object)this.elementType);
            }
        }
        return ae.getAnnotation(annotationClass);
    }

    private static void addFiles(ClassLoader loader, String resourceName, Set<File> files) throws IOException {
        Enumeration<URL> resourceEnum = loader.getResources(resourceName);
        while (resourceEnum.hasMoreElements()) {
            URL url = resourceEnum.nextElement();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resource URL: {}", (Object)url);
            }
            String protocol = url.getProtocol();
            boolean isVfs = "vfs".equals(protocol);
            if ("file".equals(protocol) || isVfs) {
                File dir = AnnotationDetector.toFile(url);
                if (dir.isDirectory()) {
                    files.add(dir);
                    continue;
                }
                if (isVfs) {
                    File jarFile;
                    String jarPath = dir.getPath();
                    int idx = jarPath.indexOf(".jar");
                    if (idx <= -1 || !(jarFile = new File(jarPath = jarPath.substring(0, idx + 4))).isFile()) continue;
                    files.add(jarFile);
                    continue;
                }
                throw AnnotationDetector.assertionError("Not a recognized file URL: %s", url);
            }
            File jarFile = AnnotationDetector.toFile(((JarURLConnection)url.openConnection()).getJarFileURL());
            if (jarFile.isFile()) {
                files.add(jarFile);
                continue;
            }
            throw AnnotationDetector.assertionError("Not a File: %s", jarFile);
        }
    }

    private static File toFile(URL url) throws IOException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detect(ClassIterator iterator) throws IOException {
        InputStream stream;
        boolean mustEndInClass = iterator instanceof ClassFileIterator;
        while ((stream = iterator.next(this.filter)) != null) {
            try {
                this.cpBuffer.readFrom(stream);
                String name = iterator.getName();
                if (!this.hasCafebabe(this.cpBuffer) || mustEndInClass && !name.endsWith(".class")) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Class File: {}", (Object)name);
                }
                this.read(this.cpBuffer);
            }
            finally {
                if (!iterator.isFile()) continue;
                stream.close();
            }
        }
    }

    private boolean hasCafebabe(ClassFileBuffer buffer) throws IOException {
        return buffer.size() > 4 && buffer.readInt() == -889275714;
    }

    private void read(DataInput di) throws IOException {
        this.readVersion(di);
        this.readConstantPoolEntries(di);
        this.readAccessFlags(di);
        this.readThisClass(di);
        this.readSuperClass(di);
        this.readInterfaces(di);
        this.readFields(di);
        this.readMethods(di);
        this.readAttributes(di, ElementType.TYPE);
    }

    private void readVersion(DataInput di) throws IOException {
        if (LOG.isTraceEnabled()) {
            int minor = di.readUnsignedShort();
            int maj = di.readUnsignedShort();
            LOG.trace("Java Class version {}.{}", (Object)maj, (Object)minor);
        } else {
            di.skipBytes(4);
        }
    }

    private void readConstantPoolEntries(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        this.constantPool = new Object[count];
        for (int i = 1; i < count; ++i) {
            if (!this.readConstantPoolEntry(di, i)) continue;
            ++i;
        }
    }

    private boolean readConstantPoolEntry(DataInput di, int index) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 16: {
                di.skipBytes(2);
                return false;
            }
            case 15: {
                di.skipBytes(3);
                return false;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                di.skipBytes(4);
                return false;
            }
            case 5: 
            case 6: {
                di.skipBytes(8);
                return true;
            }
            case 1: {
                this.constantPool[index] = di.readUTF();
                return false;
            }
            case 7: 
            case 8: {
                this.constantPool[index] = di.readUnsignedShort();
                return false;
            }
        }
        throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
    }

    private void readAccessFlags(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readThisClass(DataInput di) throws IOException {
        this.typeName = this.resolveUtf8(di);
    }

    private void readSuperClass(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readInterfaces(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        di.skipBytes(count * 2);
    }

    private void readFields(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            di.skipBytes(2);
            LOG.trace("Field: {}", (Object)this.memberName);
            this.readAttributes(di, ElementType.FIELD);
        }
    }

    private void readMethods(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            this.methodDescriptor = this.resolveUtf8(di);
            LOG.trace("Method: {}", (Object)this.memberName);
            this.readAttributes(di, "<init>".equals(this.memberName) ? ElementType.CONSTRUCTOR : ElementType.METHOD);
        }
    }

    private void readAttributes(DataInput di, ElementType reporterType) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String name = this.resolveUtf8(di);
            int length = di.readInt();
            if (this.elementTypes.contains((Object)reporterType) && ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name))) {
                LOG.trace("Attribute: {}", (Object)name);
                this.readAnnotations(di, reporterType);
                continue;
            }
            LOG.trace("Attribute: {} (ignored)", (Object)name);
            di.skipBytes(length);
        }
    }

    private void readAnnotations(DataInput di, ElementType elementType) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String rawTypeName = this.readAnnotation(di);
            this.annotationType = this.annotations.get(rawTypeName);
            if (this.annotationType == null) {
                LOG.trace("Annotation: {} (ignored)", (Object)rawTypeName);
                continue;
            }
            LOG.trace("Annotation: ''{}'' on type ''{}'', member ''{}'' (reported)", new Object[]{this.annotationType.getName(), this.getTypeName(), this.getMemberName()});
            this.elementType = elementType;
            this.reporter.report(this);
        }
    }

    private String readAnnotation(DataInput di) throws IOException {
        String rawTypeName = this.resolveUtf8(di);
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Anntotation Element: {}", (Object)this.resolveUtf8(di));
            } else {
                di.skipBytes(2);
            }
            this.readAnnotationElementValue(di);
        }
        return rawTypeName;
    }

    private void readAnnotationElementValue(DataInput di) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                di.skipBytes(2);
                break;
            }
            case 101: {
                di.skipBytes(4);
                break;
            }
            case 99: {
                di.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(di);
                break;
            }
            case 91: {
                int count = di.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue(di);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8(DataInput di) throws IOException {
        int index = di.readUnsignedShort();
        Object value = this.constantPool[index];
        String s = value instanceof Integer ? (String)this.constantPool[(Integer)value] : (String)value;
        return s;
    }

    private Class<?>[] parseArguments(String descriptor) {
        int n = descriptor.length();
        if (n < 3 || descriptor.charAt(0) != '(') {
            throw AnnotationDetector.unparseable(descriptor, "Wrong format");
        }
        LinkedList<Class<Comparable<Boolean>>> args = null;
        block14: for (int i = 1; i < n; ++i) {
            char c = descriptor.charAt(i);
            if (i == 1) {
                if (c == ')') {
                    return new Class[0];
                }
                args = new LinkedList<Class<Comparable<Boolean>>>();
            }
            switch (c) {
                case 'V': {
                    args.add(Void.TYPE);
                    continue block14;
                }
                case 'Z': {
                    args.add(Boolean.TYPE);
                    continue block14;
                }
                case 'C': {
                    args.add(Character.TYPE);
                    continue block14;
                }
                case 'B': {
                    args.add(Byte.TYPE);
                    continue block14;
                }
                case 'S': {
                    args.add(Short.TYPE);
                    continue block14;
                }
                case 'I': {
                    args.add(Integer.TYPE);
                    continue block14;
                }
                case 'F': {
                    args.add(Float.TYPE);
                    continue block14;
                }
                case 'J': {
                    args.add(Long.TYPE);
                    continue block14;
                }
                case 'D': {
                    args.add(Double.TYPE);
                    continue block14;
                }
                case '[': {
                    int j = i;
                    while ((c = descriptor.charAt(++j)) == '[') {
                    }
                    if (c == 'L') {
                        j = descriptor.indexOf(59, i + 1);
                    }
                    args.add(AnnotationDetector.loadClass(this.loader, descriptor.substring(i, j + 1)));
                    i = j;
                    continue block14;
                }
                case 'L': {
                    int j = descriptor.indexOf(59, i + 1);
                    args.add(AnnotationDetector.loadClass(this.loader, descriptor.substring(i + 1, j)));
                    i = j;
                    continue block14;
                }
                case ')': {
                    return args.toArray(new Class[args.size()]);
                }
                default: {
                    throw AnnotationDetector.unparseable(descriptor, "Not a recognoized type: " + c);
                }
            }
        }
        throw AnnotationDetector.unparseable(descriptor, "No closing parenthesis");
    }

    private static Class<?> loadClass(ClassLoader loader, String rawClassName) {
        String typeName = rawClassName.replace('/', '.');
        try {
            return Class.forName(typeName, false, loader);
        }
        catch (ClassNotFoundException ex) {
            throw AnnotationDetector.assertionError("Cannot load type '%s', scanned file not on class path? (%s)", typeName, ex);
        }
    }

    private static AssertionError unparseable(String descriptor, String cause) {
        return AnnotationDetector.assertionError("Unparseble method descriptor: '%s' (cause: %s)", descriptor, cause);
    }

    private static AssertionError assertionError(String message, Object ... args) {
        return new AssertionError((Object)String.format(message, args));
    }
}

