/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.annotation;

import dorkbox.annotation.ClassFileIterator;
import dorkbox.annotation.ClassIterator;
import dorkbox.util.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CustomClassloaderIterator
implements ClassIterator {
    private final Iterator<URL> loaderFilesIterator;
    private ClassFileIterator classFileIterator;

    public CustomClassloaderIterator(List<URL> fileNames, String[] packageNames) throws IOException {
        HashSet<File> files = new HashSet<File>();
        Iterator<URL> iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            if (url.getProtocol().equals("box")) continue;
            try {
                File file = FileUtil.normalize(new File(url.toURI()));
                files.add(file);
                iterator.remove();
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        this.classFileIterator = files.isEmpty() ? null : new ClassFileIterator(files.toArray(new File[0]), packageNames);
        this.loaderFilesIterator = fileNames.iterator();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isFile() {
        if (this.classFileIterator != null) {
            return this.classFileIterator.isFile();
        }
        return false;
    }

    @Override
    public InputStream next(FilenameFilter filter) throws IOException {
        if (this.classFileIterator != null) {
            InputStream next;
            while (true) {
                if ((next = this.classFileIterator.next(filter)) == null) {
                    this.classFileIterator = null;
                    continue;
                }
                String name = this.classFileIterator.getName();
                if (name.endsWith(".class")) break;
            }
            return next;
        }
        if (this.loaderFilesIterator.hasNext()) {
            URL next = this.loaderFilesIterator.next();
            return next.openStream();
        }
        return null;
    }
}

