/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.annotation;

import java.io.File;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;

final class FileIterator {
    private final Deque<File> stack = new LinkedList<File>();
    private int rootCount;
    private File currentRoot;
    private File current;

    FileIterator(File ... filesOrDirectories) {
        this.addReverse(filesOrDirectories);
        this.rootCount = this.stack.size();
    }

    File getFile() {
        return this.current;
    }

    File getRootFile() {
        return this.currentRoot;
    }

    String relativize(String path) {
        assert (path.startsWith(this.currentRoot.getPath()));
        return path.substring(this.currentRoot.getPath().length() + 1);
    }

    boolean isRootFile() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.stack.size() < this.rootCount;
    }

    File next() {
        if (this.stack.isEmpty()) {
            this.current = null;
            return null;
        }
        this.current = this.stack.removeLast();
        if (this.current.isDirectory()) {
            if (this.stack.size() < this.rootCount) {
                this.rootCount = this.stack.size();
                this.currentRoot = this.current;
            }
            this.addReverse(this.current.listFiles());
            return this.next();
        }
        return this.current;
    }

    private void addReverse(File[] files) {
        for (int i = files.length - 1; i >= 0; --i) {
            this.stack.add(files[i]);
        }
    }
}

