/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectMap;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u0000 m*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006mnopqrB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010E\u001a\u00020FH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0003H\u0016J\u0010\u0010H\u001a\u00020\u00152\u0006\u0010I\u001a\u00020\u0003H\u0016J\u0015\u0010J\u001a\u00020\u00152\u0006\u0010K\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010LJ\u001a\u0010J\u001a\u00020\u00152\b\u0010K\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\u0015H\u0016J\u000e\u0010O\u001a\u00020F2\u0006\u0010P\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0012H\u0016J\u0013\u0010Q\u001a\u00020\u00152\b\u0010R\u001a\u0004\u0018\u00010MH\u0096\u0002J\u0012\u0010S\u001a\u00020\u00152\b\u0010R\u001a\u0004\u0018\u00010MH\u0016J\u001f\u0010T\u001a\u0004\u0018\u00010\u00032\b\u0010K\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\u0015\u00a2\u0006\u0002\u0010UJ \u0010T\u001a\u00020\u00032\b\u0010K\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020\u00152\u0006\u0010V\u001a\u00020\u0003J\u0018\u0010W\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010XJ \u0010W\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020\u00032\u0006\u0010Y\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010ZJ\b\u0010[\u001a\u00020\u0003H\u0016J\b\u0010\\\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020#H\u0016J\u0010\u0010]\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u0003H\u0002J\u0006\u0010^\u001a\u00020\u0015J\u0010\u0010_\u001a\u00020\u00032\u0006\u0010`\u001a\u00020\u0003H\u0004J\u001f\u0010a\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020\u00032\u0006\u0010K\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010ZJ\u0018\u0010b\u001a\u00020F2\u000e\u0010c\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010b\u001a\u00020F2\u0014\u0010c\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000dH\u0016J\u001f\u0010e\u001a\u00020F2\u0006\u0010I\u001a\u00020\u00032\b\u0010K\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010fJ\u0017\u0010g\u001a\u0004\u0018\u00018\u00002\u0006\u0010I\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010XJ\u0010\u0010h\u001a\u00020F2\u0006\u0010i\u001a\u00020\u0003H\u0002J\u0010\u0010j\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0003H\u0016J\b\u0010k\u001a\u00020lH\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000=H\u0016R,\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\r0\f8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010'R\u000e\u0010/\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00107\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00028\u0000098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0016\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010?\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010D\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006s"}, d2={"Ldorkbox/collections/IntMap;", "V", "", "", "()V", "initialCapacity", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/IntMap;)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/IntMap$Entries;", "entries2", "hasZeroValue", "", "getHasZeroValue", "()Z", "setHasZeroValue", "(Z)V", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/IntMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[Ljava/lang/Object;", "setValueTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/IntMap$Values;", "values2", "zeroValue", "getZeroValue", "()Ljava/lang/Object;", "setZeroValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Integer;", "notFound", "get", "(I)Ljava/lang/Object;", "defaultValue", "(ILjava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(ILjava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nIntMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1034:1\n1#2:1035\n1855#3,2:1036\n*S KotlinDebug\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap\n*L\n300#1:1036,2\n*E\n"})
public class IntMap<V>
implements Map<Integer, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    @NotNull
    private int[] keyTable;
    @NotNull
    private V[] valueTable;
    @Nullable
    private V zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient Entries<V> entries1;
    @Nullable
    private transient Entries<V> entries2;
    @Nullable
    private transient Values<V> values1;
    @Nullable
    private transient Values<V> values2;
    @Nullable
    private transient Keys keys1;
    @Nullable
    private transient Keys keys2;
    @NotNull
    public static final String version = "2.4";

    @NotNull
    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.keyTable = nArray;
    }

    @NotNull
    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"<set-?>");
        this.valueTable = VArray;
    }

    @Nullable
    public final V getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(@Nullable V v) {
        this.zeroValue = v;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public /* synthetic */ IntMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntMap(@NotNull IntMap<? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size_ = map.size_;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
    }

    protected final int place(int item) {
        return (int)((long)item * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    @Nullable
    public V put(int key, V value) {
        if (key == 0) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                int n = this.size_;
                this.size_ = n + 1;
            }
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public void putAll(@NotNull IntMap<? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size_);
        if (from.hasZeroValue) {
            V v = from.zeroValue;
            Intrinsics.checkNotNull(v);
            this.put(0, v);
        }
        int[] keyTable = from.keyTable;
        V[] valueTable = from.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            V v = valueTable[i];
            Intrinsics.checkNotNull(v);
            this.put(key, v);
        }
    }

    private final void putResize(int key, V value) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Nullable
    public V get(int key) {
        if (key == 0) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        int i = this.locateKey(key);
        return i >= 0 ? (V)this.valueTable[i] : null;
    }

    @Nullable
    public final V get(int key, V defaultValue) {
        if (key == 0) {
            V v;
            if (this.hasZeroValue) {
                V v2 = this.zeroValue;
                v = v2;
                Intrinsics.checkNotNull(v2);
            } else {
                v = defaultValue;
            }
            return v;
        }
        int i = this.locateKey(key);
        return i >= 0 ? this.valueTable[i] : defaultValue;
    }

    @Nullable
    public V remove(int key) {
        int n;
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            int n2 = this.size_;
            this.size_ = n2 + -1;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        int k = 0;
        while (true) {
            int it = n = keyTable[next];
            boolean bl = false;
            k = it;
            if (n == 0) break;
            int placement = this.place(k);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0;
        valueTable[i] = null;
        n = this.size_;
        this.size_ = n + -1;
        return oldValue;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(@NotNull Map<? extends Integer, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size());
        Iterable $this$forEach$iv = from.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            int k = ((Number)entry.getKey()).intValue();
            Object v = entry.getValue();
            this.put(k, v);
        }
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(tableSize);
    }

    @NotNull
    public Set<Map.Entry<Integer, V>> getEntries() {
        Entries<V> entries = this.entries();
        Intrinsics.checkNotNull(entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<kotlin.Int, V of dorkbox.collections.IntMap>>");
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    @NotNull
    public Set<Integer> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    @NotNull
    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value, false);
    }

    public boolean containsValue(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0 || valueTable[i] != null) continue;
                    return true;
                } while (0 <= n);
            }
        } else if (identity) {
            if (value == this.zeroValue) {
                return true;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)value, this.zeroValue)) {
                return true;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return key == 0 ? this.hasZeroValue : this.locateKey(key) >= 0;
    }

    @Nullable
    public final Integer findKey(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0 || valueTable[i] != null) continue;
                    return keyTable[i];
                } while (0 <= n);
            }
        } else if (identity) {
            if (value == this.zeroValue) {
                return 0;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)value, this.zeroValue)) {
                return 0;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final int findKey(@Nullable Object value, boolean identity, int notFound) {
        Integer n = this.findKey(value, identity);
        return n != null ? n : notFound;
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.size_ + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize];
        this.valueTable = new Object[newSize];
        if (this.size_ > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size_;
        if (this.hasZeroValue && this.zeroValue != null) {
            V v = this.zeroValue;
            h += v != null ? v.hashCode() : 0;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0) continue;
            h += key * 31;
            V value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntMap)) {
            return false;
        }
        IntMap cfr_ignored_0 = (IntMap)other;
        if (((IntMap)other).size_ != this.size_) {
            return false;
        }
        if (((IntMap)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntMap)other).zeroValue == null ? this.zeroValue != null : !Intrinsics.areEqual(((IntMap)other).zeroValue, this.zeroValue))) {
            return false;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            int key = keyTable[i];
            if (key == 0 || !((value = valueTable[i]) == null ? ((IntMap)other).get(key, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(value, ((IntMap)other).get((Object)key)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntMap)) {
            return false;
        }
        IntMap cfr_ignored_0 = (IntMap)other;
        if (((IntMap)other).size_ != this.size_) {
            return false;
        }
        if (((IntMap)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((IntMap)other).zeroValue) {
            return false;
        }
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            int key = keyTable[i];
            if (key == 0 || valueTable[i] == ((IntMap)other).get(key, ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        int key;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public Entries<V> entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap<V of dorkbox.collections.IntMap?>");
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap<V of dorkbox.collections.IntMap?>");
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap.Entries<V of dorkbox.collections.IntMap?>");
            return entries5;
        }
        Entries<V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap.Entries<V of dorkbox.collections.IntMap?>");
        return entries9;
    }

    @Override
    @NotNull
    public Values<V> values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap.Values<V of dorkbox.collections.IntMap>");
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap.Values<V of dorkbox.collections.IntMap>");
        return values9;
    }

    @NotNull
    public Keys keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Keys((IntMap<?>)this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys((IntMap<?>)this);
            this.keys2 = new Keys((IntMap<?>)this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u00022\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\t\u0010\u0017\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0017\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u001aH\u0096\u0002J\u0011\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u001d\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\u001e\u0010\u001e\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Ldorkbox/collections/IntMap$Entries;", "V", "", "Ldorkbox/collections/IntMap$Entry;", "Ldorkbox/collections/IntMap$MapIterator;", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "entry", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1037\n288#2,2:1039\n288#2,2:1042\n1855#2,2:1045\n13600#3:1041\n13601#3:1044\n*S KotlinDebug\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Entries\n*L\n750#1:1035,2\n771#1:1037,2\n792#1:1039,2\n802#1:1042,2\n813#1:1045,2\n800#1:1041\n800#1:1044\n*E\n"})
    public static final class Entries<V>
    extends MapIterator<V, Entry<V>>
    implements Set<Entry<V>>,
    KMutableSet {
        @NotNull
        private final Entry<V> entry;

        public Entries(@NotNull IntMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.entry = new Entry<V>(map);
        }

        @Override
        @NotNull
        public Entry<V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] keyTable = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(keyTable[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.getMap().put(element.getKey(), element.getValue());
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry<V>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                this.getMap().put(it.getKey(), it.getValue());
                added = true;
            }
            return added;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                int k = ((Number)((Map.Entry)entry).getKey()).intValue();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.getMap().get((Object)k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return Intrinsics.areEqual(this.getMap().get(element.getKey()), element.getValue());
        }

        @Override
        @NotNull
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            if (this.getMap().getHasZeroValue()) {
                boolean hasElement;
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv;
                        boolean bl = false;
                        if (!(it.getKey() == 0)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) {
                    removed = this.getMap().remove((Object)0) != null;
                }
            }
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v2;
                int key;
                block6: {
                    int element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == 0) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getKey() == key)) continue;
                        v2 = element$iv2;
                        break block6;
                    }
                    v2 = null;
                }
                boolean bl = hasElement = v2 != null;
                if (hasElement) continue;
                removed = this.getMap().remove((Object)key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                int k = ((Number)((Map.Entry)entry).getKey()).intValue();
                removed = this.getMap().remove((Object)k) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            boolean removed = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return removed;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\t\u0010\u0016\u001a\u00020\fH\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\u0002\u0010!R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/IntMap$Values;", "V", "", "Ldorkbox/collections/IntMap$MapIterator;", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1039\n13600#3,2:1037\n*S KotlinDebug\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Values\n*L\n864#1:1035,2\n897#1:1039,2\n882#1:1037,2\n*E\n"})
    public static final class Values<V>
    extends MapIterator<V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(@NotNull IntMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            V value = null;
            value = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            V v = value;
            Intrinsics.checkNotNull(v);
            return v;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().containsValue(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object element) {
            return this.getMap().containsValue(element);
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                int element$iv;
                int key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == 0 || CollectionsKt.contains((Iterable)elements, value = this.getMap().get((Object)key))) continue;
                this.getMap().remove((Object)key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Integer key = this.getMap().findKey(it, false);
                if (key == null) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(Object element) {
            boolean removed = false;
            Integer key = this.getMap().findKey(element, false);
            if (key != null) {
                removed = this.getMap().remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public final V[] toArray() {
            int n = 0;
            int n2 = this.getMap().size_;
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next(), (String)"null cannot be cast to non-null type kotlin.Any");
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\t\u0010\u0015\u001a\u00020\fH\u0096\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/IntMap$Keys;", "", "", "Ldorkbox/collections/IntMap$MapIterator;", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1037\n1855#2,2:1041\n13600#3,2:1039\n*S KotlinDebug\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$Keys\n*L\n950#1:1035,2\n966#1:1037,2\n997#1:1041,2\n984#1:1039,2\n*E\n"})
    public static final class Keys
    extends MapIterator<Object, Integer>
    implements Set<Integer>,
    KMutableSet {
        public Keys(@NotNull IntMap<?> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.getNextIndex() == -1 ? 0 : this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return key;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Integer> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean alreadyAdded = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                alreadyAdded = alreadyAdded || this.getMap().put(it, (Object)null) == null;
            }
            return alreadyAdded;
        }

        @Override
        public boolean add(int element) {
            return this.getMap().put(element, (Object)null) == null;
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (this.getMap().containsKey((Object)it)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(int element) {
            return this.getMap().containsKey((Object)element);
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            int[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (elements.contains(it) || this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@Nullable Integer element) {
            return this.getMap().remove(element) == null;
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.getMap().size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @NotNull
        public final int[] toArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/IntMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ldorkbox/collections/IntMap$Entry;", "V", "", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "key", "getKey", "()Ljava/lang/Integer;", "setKey", "(I)V", "getMap", "()Ldorkbox/collections/IntMap;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<V>
    implements Map.Entry<Integer, V>,
    KMutableMap.Entry {
        @NotNull
        private final IntMap<V> map;
        private int key;
        @Nullable
        private V value;

        public Entry(@NotNull IntMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final IntMap<V> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        public void setKey(int n) {
            this.key = n;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable V v) {
            this.value = v;
        }

        @Override
        @Nullable
        public V setValue(@Nullable V newValue) {
            V oldValue = this.getValue();
            ((Map)this.map).put(this.getKey(), newValue);
            this.setValue(newValue);
            return oldValue;
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/IntMap;", "(Ldorkbox/collections/IntMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/IntMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntMap.kt\ndorkbox/collections/IntMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1034:1\n1#2:1035\n*E\n"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IntMap<V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(@NotNull IntMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final IntMap<V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                int[] keyTable = this.map.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(null);
            } else {
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.map.getKeyTable();
                V[] valueTable = this.map.getValueTable();
                int mask = this.map.getMask();
                int next = i + 1 & mask;
                int key = 0;
                while (true) {
                    int n;
                    int it = n = keyTable[next];
                    boolean bl = false;
                    key = it;
                    if (n == 0) break;
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0;
                valueTable[i] = null;
                if (i != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                IntMap<V> intMap = this.map;
                int n = ((IntMap)intMap).size_;
                ((IntMap)intMap).size_ = n + -1;
            }
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

