/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 z*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004:\u0006z{|}~\u007fB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\fJ\b\u0010Q\u001a\u00020RH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0016J\u0015\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010WJ\u0017\u0010X\u001a\u00020U2\b\u0010Y\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010WJ\u001a\u0010X\u001a\u00020U2\b\u0010Y\u001a\u0004\u0018\u00010\u00022\u0006\u0010Z\u001a\u00020UH\u0016J\u000e\u0010[\u001a\u00020R2\u0006\u0010\\\u001a\u00020\u0007J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0013H\u0016J\u0013\u0010]\u001a\u00020U2\b\u0010^\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0012\u0010_\u001a\u00020U2\b\u0010^\u001a\u0004\u0018\u00010\u0002H\u0016J\u001f\u0010`\u001a\u0004\u0018\u00018\u00002\b\u0010Y\u001a\u0004\u0018\u00010\u00022\u0006\u0010Z\u001a\u00020U\u00a2\u0006\u0002\u0010aJ\u0018\u0010b\u001a\u0004\u0018\u00018\u00012\u0006\u0010V\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010cJ \u0010b\u001a\u0004\u0018\u00018\u00012\u0006\u0010V\u001a\u00028\u00002\u0006\u0010d\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010eJ\b\u0010f\u001a\u00020\u0007H\u0016J\b\u0010g\u001a\u00020UH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0010\u0010h\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\u0002H\u0016J\u0006\u0010i\u001a\u00020UJ\u0010\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u0002H\u0014J!\u0010l\u001a\u0004\u0018\u00018\u00012\u0006\u0010V\u001a\u00028\u00002\b\u0010Y\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010eJ\"\u0010m\u001a\u00020R2\u0018\u0010n\u001a\u0014\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00010\u0000H\u0016J \u0010m\u001a\u00020R2\u0016\u0010n\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010oH\u0016J\u001f\u0010p\u001a\u00020R2\u0006\u0010V\u001a\u00028\u00002\b\u0010Y\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010qJ\u0017\u0010r\u001a\u0004\u0018\u00018\u00012\u0006\u0010V\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010cJ\u000e\u0010s\u001a\u00020R2\u0006\u0010t\u001a\u00020\u0007J\u0010\u0010u\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0007H\u0016J\b\u0010v\u001a\u00020wH\u0016J\u000e\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020wJ\u0018\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020w2\u0006\u0010y\u001a\u00020UH\u0014J\u0010\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010IH\u0016R(\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R$\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\"\u0010$\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\u001a\u00109\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00103\"\u0004\b;\u00105R\u0014\u0010<\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u00103R\u001a\u0010>\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00103\"\u0004\b@\u00105R$\u0010A\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\bB\u0010\u001e\"\u0004\bC\u0010 R\u001c\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR$\u0010H\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR$\u0010N\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010K\"\u0004\bP\u0010M\u00a8\u0006\u0080\u0001"}, d2={"Ldorkbox/collections/ObjectMap;", "K", "", "V", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/ObjectMap;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ObjectMap$Entries;", "getEntries1", "()Ldorkbox/collections/ObjectMap$Entries;", "setEntries1", "(Ldorkbox/collections/ObjectMap$Entries;)V", "entries2", "getEntries2", "setEntries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ObjectMap$Keys;", "getKeys1", "()Ldorkbox/collections/ObjectMap$Keys;", "setKeys1", "(Ldorkbox/collections/ObjectMap$Keys;)V", "keys2", "getKeys2", "setKeys2", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mapSize", "getMapSize", "()I", "setMapSize", "(I)V", "mask", "getMask", "setMask", "shift", "getShift", "setShift", "size", "getSize", "threshold", "getThreshold", "setThreshold", "valueTable", "getValueTable", "setValueTable", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ObjectMap$Values;", "getValues1", "()Ldorkbox/collections/ObjectMap$Values;", "setValues1", "(Ldorkbox/collections/ObjectMap$Values;)V", "values2", "getValues2", "setValues2", "clear", "", "maximumCapacity", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "separator", "braces", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nObjectMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,988:1\n215#2,2:989\n1#3:991\n*S KotlinDebug\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap\n*L\n226#1:989,2\n*E\n"})
public class ObjectMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mapSize;
    @NotNull
    private K[] keyTable;
    @NotNull
    private V[] valueTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient Entries<K, V> entries1;
    @Nullable
    private transient Entries<K, V> entries2;
    @Nullable
    private transient Values<V> values1;
    @Nullable
    private transient Values<V> values2;
    @Nullable
    private transient Keys<K> keys1;
    @Nullable
    private transient Keys<K> keys2;
    @NotNull
    public static final String version = "2.4";
    @NotNull
    private static final Object dummy = new Object();

    protected final int getMapSize() {
        return this.mapSize;
    }

    protected final void setMapSize(int n) {
        this.mapSize = n;
    }

    @NotNull
    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"<set-?>");
        this.keyTable = KArray;
    }

    @NotNull
    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"<set-?>");
        this.valueTable = VArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    @Nullable
    public final Entries<K, V> getEntries1() {
        return this.entries1;
    }

    public final void setEntries1(@Nullable Entries<K, V> entries) {
        this.entries1 = entries;
    }

    @Nullable
    public final Entries<K, V> getEntries2() {
        return this.entries2;
    }

    public final void setEntries2(@Nullable Entries<K, V> entries) {
        this.entries2 = entries;
    }

    @Nullable
    public final Values<V> getValues1() {
        return this.values1;
    }

    public final void setValues1(@Nullable Values<V> values) {
        this.values1 = values;
    }

    @Nullable
    public final Values<V> getValues2() {
        return this.values2;
    }

    public final void setValues2(@Nullable Values<V> values) {
        this.values2 = values;
    }

    @Nullable
    public final Keys<K> getKeys1() {
        return this.keys1;
    }

    public final void setKeys1(@Nullable Keys<K> keys) {
        this.keys1 = keys;
    }

    @Nullable
    public final Keys<K> getKeys2() {
        return this.keys2;
    }

    public final void setKeys2(@Nullable Keys<K> keys) {
        this.keys2 = keys;
    }

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public /* synthetic */ ObjectMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectMap(@NotNull ObjectMap<? extends K, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.mapSize = map.mapSize;
    }

    public int getSize() {
        return this.mapSize;
    }

    protected int place(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public int locateKey(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (keyTable[i] != null) {
            K other;
            if (Intrinsics.areEqual(other, (Object)key)) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @Nullable V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public void putAll(@NotNull ObjectMap<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.mapSize);
        K[] keyTable = from.keyTable;
        V[] valueTable = from.valueTable;
        K key = null;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size());
        Map<K, V> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> element$iv;
            Map.Entry<K, V> entry = element$iv = iterator.next();
            boolean bl = false;
            K k = entry.getKey();
            V v = entry.getValue();
            this.put(k, v);
        }
    }

    private final void putResize(K key, V value) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int i = this.locateKey(key);
        return i < 0 ? null : (V)this.valueTable[i];
    }

    @Nullable
    public final V get(@NotNull K key, V defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        return i < 0 ? defaultValue : this.valueTable[i];
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        Object k = null;
        while (true) {
            K k2;
            K it = k2 = keyTable[next];
            boolean bl = false;
            k = it;
            if (k2 == null) break;
            Object v0 = k;
            Intrinsics.checkNotNull(v0);
            int placement = this.place(v0);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        valueTable[i] = null;
        int n = this.mapSize;
        this.mapSize = n + -1;
        return oldValue;
    }

    public final boolean notEmpty() {
        return this.mapSize > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.mapSize == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.mapSize = 0;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.mapSize == 0) {
            return;
        }
        this.mapSize = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.containsValue(value, false);
    }

    public boolean containsValue(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            K[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == null || valueTable[i] != null) continue;
                    return true;
                } while (0 <= n);
            }
        } else if (identity) {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        return this.locateKey(key) >= 0;
    }

    @Nullable
    public final K findKey(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            K[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == null || valueTable[i] != null) continue;
                    return keyTable[i];
                } while (0 <= n);
            }
        } else if (identity) {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        } else {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.mapSize + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    public final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new Object[newSize];
        if (this.mapSize > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                K key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.mapSize;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            h += key.hashCode();
            V value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjectMap)) {
            return false;
        }
        ObjectMap cfr_ignored_0 = (ObjectMap)other;
        if (((ObjectMap)other).size() != this.mapSize) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            K key = keyTable[i];
            if (key == null || !((value = valueTable[i]) == null ? ((ObjectMap)other).get(key, dummy) != null : !Intrinsics.areEqual(value, ((ObjectMap)other).get(key)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjectMap)) {
            return false;
        }
        ObjectMap cfr_ignored_0 = (ObjectMap)other;
        if (((ObjectMap)other).size() != this.mapSize) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null || valueTable[i] == ((ObjectMap)other).get(key, dummy)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return this.toString(separator, false);
    }

    @NotNull
    public String toString() {
        return this.toString(", ", true);
    }

    @NotNull
    protected String toString(@NotNull String separator, boolean braces) {
        V value;
        K key;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (this.mapSize == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            K k = keyTable[i];
            if (k == null) continue;
            key = k;
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append((Object)(value == this ? "(this)" : value));
            break;
        }
        while (i-- > 0) {
            if (keyTable[i] == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        Entries<K, V> entries = this.entries();
        Intrinsics.checkNotNull(entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>>");
        return TypeIntrinsics.asMutableSet(entries);
    }

    @NotNull
    public Entries<K, V> entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K, V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<K, V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<K, V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<K, V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<K, V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap.Entries<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
            return entries5;
        }
        Entries<K, V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<K, V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<K, V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<K, V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap.Entries<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
        return entries9;
    }

    @NotNull
    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    @NotNull
    public Values<V> values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap<K of dorkbox.collections.ObjectMap, V of dorkbox.collections.ObjectMap?>");
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap.Values<V of dorkbox.collections.ObjectMap?>");
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap.Values<V of dorkbox.collections.ObjectMap?>");
        return values9;
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keys();
    }

    @NotNull
    public Keys<K> keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.reset();
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.reset();
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u00042$\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u0003\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u0006B\u001b\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\u0016\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001f\u0010\u001b\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J$\u0010\u001c\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J\t\u0010\u001d\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0017\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0000H\u0096\u0002J\u0017\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J\u001e\u0010!\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\"\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016J$\u0010#\u001a\u00020\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0018H\u0016R*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u0003\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Ldorkbox/collections/ObjectMap$Entries;", "K", "", "V", "", "Ldorkbox/collections/ObjectMap$Entry;", "Ldorkbox/collections/ObjectMap$MapIterator;", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "entry", "getEntry$Collections", "()Ldorkbox/collections/ObjectMap$Entry;", "setEntry$Collections", "(Ldorkbox/collections/ObjectMap$Entry;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,988:1\n1855#2,2:989\n1855#2,2:991\n288#2,2:994\n1855#2,2:997\n13579#3:993\n13580#3:996\n*S KotlinDebug\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Entries\n*L\n719#1:989,2\n740#1:991,2\n760#1:994,2\n772#1:997,2\n758#1:993\n758#1:996\n*E\n"})
    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>>
    implements Set<Entry<K, V>>,
    KMutableSet {
        @Nullable
        private Entry<K, V> entry;

        public Entries(@NotNull ObjectMap<K, V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Nullable
        public final Entry<K, V> getEntry$Collections() {
            return this.entry;
        }

        public final void setEntry$Collections(@Nullable Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        @NotNull
        public Entry<K, V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K[] keyTable = this.getMap().getKeyTable();
            if (this.entry == null) {
                Object k = keyTable[this.getNextIndex()];
                Intrinsics.checkNotNull(k);
                this.entry = new Entry(k, this.getMap().getValueTable()[this.getNextIndex()], this.getMap());
            } else {
                Entry entry = this.entry;
                Intrinsics.checkNotNull(entry);
                Object k = keyTable[this.getNextIndex()];
                Intrinsics.checkNotNull(k);
                entry.setKey(k);
                Entry entry2 = this.entry;
                Intrinsics.checkNotNull(entry2);
                entry2.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Entry<K, V> entry = this.entry;
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.getMap().put(element.getKey(), element.getValue());
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry<K, V>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                this.getMap().put(it.getKey(), it.getValue());
                added = true;
            }
            return added;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.getMap().get(k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return Intrinsics.areEqual(this.getMap().get(element.getKey()), element.getValue());
        }

        @NotNull
        public Entries<K, V> iterator() {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectMap.Entries<K of dorkbox.collections.ObjectMap.Entries, V of dorkbox.collections.ObjectMap.Entries?>");
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v0;
                Object key;
                block2: {
                    Object element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == null) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getKey(), key)) continue;
                        v0 = element$iv2;
                        break block2;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                removed = this.getMap().remove(k) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            ObjectMap objectMap = this.getMap();
            Entry<K, V> entry = this.entry;
            Intrinsics.checkNotNull(entry);
            boolean removed = objectMap.remove(entry.getKey()) != null;
            this.reset();
            return removed;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0015\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020 H\u0016\u00a2\u0006\u0002\u0010!J-\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\"0 \"\b\b\u0003\u0010\"*\u00028\u00022\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectMap$Values;", "V", "", "Ldorkbox/collections/ObjectMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,988:1\n1855#2,2:989\n1855#2,2:993\n13579#3,2:991\n*S KotlinDebug\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Values\n*L\n822#1:989,2\n855#1:993,2\n840#1:991,2\n*E\n"})
    public static class Values<V>
    extends MapIterator<Object, V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(@NotNull ObjectMap<?, V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object value = this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Object v = value;
            Intrinsics.checkNotNull(v);
            return v;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().containsValue(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object element) {
            return this.getMap().containsValue(element);
        }

        @Override
        @NotNull
        public Values<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                Object element$iv;
                Object key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == null || CollectionsKt.contains((Iterable)elements, value = this.getMap().get(key))) continue;
                this.getMap().remove(key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object key = this.getMap().findKey(it, false);
                if (key == null) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(Object element) {
            boolean removed = false;
            Object key = this.getMap().findKey(element, false);
            if (key != null) {
                removed = this.getMap().remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public V[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next(), (String)"null cannot be cast to non-null type kotlin.Any");
            }
            return objectArray;
        }

        @Override
        @NotNull
        public final <T extends V> T[] toArray(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                array[index++] = this.next();
            }
            return array;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012H\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00020 H\u0016\u00a2\u0006\u0002\u0010!J)\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \"\b\b\u0003\u0010\"*\u00028\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectMap$Keys;", "K", "", "", "Ldorkbox/collections/ObjectMap$MapIterator;", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,988:1\n1855#2,2:989\n1855#2,2:993\n13579#3,2:991\n*S KotlinDebug\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$Keys\n*L\n927#1:989,2\n957#1:993,2\n945#1:991,2\n*E\n"})
    public static class Keys<K>
    extends MapIterator<K, Object, K>
    implements Set<K>,
    KMutableSet {
        public Keys(@NotNull ObjectMap<K, ?> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public K next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Object k = key;
            Intrinsics.checkNotNull(k);
            return k;
        }

        @Override
        public boolean add(@NotNull K element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().containsKey(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            return this.getMap().containsKey(element);
        }

        @Override
        @NotNull
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (it == null || elements.contains(it)) continue;
                this.getMap().remove(it);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().remove(it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            boolean removed = this.getMap().remove(element) == null;
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public K[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next(), (String)"null cannot be cast to non-null type kotlin.Any");
            }
            return objectArray;
        }

        @Override
        @NotNull
        public final <T extends K> T[] toArray(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                int n = index++;
                K k = this.next();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type T of dorkbox.collections.ObjectMap.Keys.toArray");
                array[n] = k;
            }
            return array;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/collections/ObjectMap$Companion;", "", "()V", "dummy", "getDummy$Collections", "()Ljava/lang/Object;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getDummy$Collections() {
            return dummy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004B+\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u0012\u001a\u0004\u0018\u00018\u00032\b\u0010\u0013\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0005\u001a\u00028\u0002X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0003X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/ObjectMap$Entry;", "K", "", "V", "", "key", "value", "map", "Ldorkbox/collections/ObjectMap;", "(Ljava/lang/Object;Ljava/lang/Object;Ldorkbox/collections/ObjectMap;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ObjectMap;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        @NotNull
        private final ObjectMap<K, V> map;
        @NotNull
        private K key;
        @Nullable
        private V value;

        public Entry(@NotNull K key, V value, @NotNull ObjectMap<K, V> map) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final ObjectMap<K, V> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public K getKey() {
            return this.key;
        }

        public void setKey(@NotNull K k) {
            Intrinsics.checkNotNullParameter(k, (String)"<set-?>");
            this.key = k;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable V v) {
            this.value = v;
        }

        @Override
        @Nullable
        public V setValue(@Nullable V newValue) {
            V oldValue = this.getValue();
            ((Map)this.map).put(this.getKey(), newValue);
            this.setValue(newValue);
            return oldValue;
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u0003*\u0004\b\u0004\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00040\u0005B\u001b\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000eR\u001a\u0010\u001a\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006!"}, d2={"Ldorkbox/collections/ObjectMap$MapIterator;", "K", "", "V", "I", "", "map", "Ldorkbox/collections/ObjectMap;", "(Ldorkbox/collections/ObjectMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/ObjectMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectMap.kt\ndorkbox/collections/ObjectMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,988:1\n1#2:989\n*E\n"})
    public static abstract class MapIterator<K, V, I>
    implements Iterator<I>,
    KMutableIterator {
        @NotNull
        private final ObjectMap<K, V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public MapIterator(@NotNull ObjectMap<K, V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final ObjectMap<K, V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                K[] keyTable = this.map.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int i = this.currentIndex;
            if (!(i >= 0)) {
                boolean $i$a$-check-ObjectMap$MapIterator$remove$22 = false;
                String $i$a$-check-ObjectMap$MapIterator$remove$22 = "next must be called before remove.";
                throw new IllegalStateException($i$a$-check-ObjectMap$MapIterator$remove$22.toString());
            }
            K[] keyTable = this.map.getKeyTable();
            V[] valueTable = this.map.getValueTable();
            int mask = this.map.getMask();
            int next = i + 1 & mask;
            Object key = null;
            while (true) {
                object = keyTable[next];
                K it = object;
                boolean bl = false;
                key = it;
                if (object == null) break;
                Object v0 = key;
                Intrinsics.checkNotNull(v0);
                int placement = this.map.place(v0);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            valueTable[i] = null;
            object = this.map;
            int n = ((ObjectMap)object).getMapSize();
            ((ObjectMap)object).setMapSize(n + -1);
            if (i != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }
    }
}

