/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ExpandingArray;
import dorkbox.collections.ObjectMap;
import dorkbox.collections.StateException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b.\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 ~*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004:\b~\u007f\u0080\u0001\u0081\u0001\u0082\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001b\b\u0016\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB3\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000fB#\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u0010B\u001b\b\u0016\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\u0012J\b\u0010<\u001a\u00020=H\u0016J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0007J\u0017\u0010?\u001a\u00020\n2\b\u0010@\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010AJ\u0015\u0010B\u001a\u00020\n2\u0006\u0010@\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010AJ\u0006\u0010C\u001a\u00020\nJ\u0017\u0010D\u001a\u00020\n2\b\u0010E\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010AJ\u001d\u0010D\u001a\u00020\n2\b\u0010E\u001a\u0004\u0018\u00018\u00012\u0006\u0010F\u001a\u00020\n\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020\u0007J\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001aJ\u0013\u0010J\u001a\u00020\n2\b\u0010K\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u000e\u0010L\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u0002J\r\u0010M\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010NJ\r\u0010O\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010NJ\u0018\u0010P\u001a\u0004\u0018\u00018\u00012\u0006\u0010@\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010QJ\"\u0010P\u001a\u0004\u0018\u00018\u00012\b\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010R\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010SJ\u001f\u0010T\u001a\u0004\u0018\u00018\u00002\b\u0010E\u001a\u0004\u0018\u00018\u00012\u0006\u0010F\u001a\u00020\n\u00a2\u0006\u0002\u0010UJ\u0015\u0010V\u001a\u0004\u0018\u00018\u00002\u0006\u0010W\u001a\u00020\u0007\u00a2\u0006\u0002\u0010XJ\u0015\u0010Y\u001a\u0004\u0018\u00018\u00012\u0006\u0010W\u001a\u00020\u0007\u00a2\u0006\u0002\u0010XJ\b\u0010Z\u001a\u00020\u0007H\u0016J\u0015\u0010[\u001a\u00020\u00072\b\u0010@\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\\J\u001d\u0010]\u001a\u00020\u00072\b\u0010E\u001a\u0004\u0018\u00018\u00012\u0006\u0010F\u001a\u00020\n\u00a2\u0006\u0002\u0010^J#\u0010_\u001a\u00020=2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010@\u001a\u00028\u00002\u0006\u0010E\u001a\u00028\u0001\u00a2\u0006\u0002\u0010`J\b\u0010a\u001a\u00020\nH\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0006\u0010b\u001a\u00020\nJ\r\u0010c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010NJ\r\u0010d\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010NJ#\u0010e\u001a\u00020\u00072\u0006\u0010@\u001a\u00028\u00002\u0006\u0010E\u001a\u00028\u00012\u0006\u0010W\u001a\u00020\u0007\u00a2\u0006\u0002\u0010fJ!\u0010e\u001a\u0004\u0018\u00018\u00012\u0006\u0010@\u001a\u00028\u00002\b\u0010E\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010SJ2\u0010g\u001a\u00020=2\u0016\u0010h\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u00002\b\b\u0002\u0010i\u001a\u00020\u00072\b\b\u0002\u0010j\u001a\u00020\u0007J \u0010g\u001a\u00020=2\u0016\u0010k\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010lH\u0016J\u001d\u0010m\u001a\u00020\u00072\u0006\u0010@\u001a\u00028\u00002\b\u0010E\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010nJ\u0017\u0010o\u001a\u0004\u0018\u00018\u00012\u0006\u0010@\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010QJ\u000e\u0010p\u001a\u00020=2\u0006\u0010W\u001a\u00020\u0007J\u0017\u0010q\u001a\u0004\u0018\u00018\u00012\b\u0010@\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010QJ\u001d\u0010r\u001a\u00020\n2\b\u0010E\u001a\u0004\u0018\u00018\u00012\u0006\u0010F\u001a\u00020\n\u00a2\u0006\u0002\u0010GJ\u0010\u0010s\u001a\u00020=2\u0006\u0010t\u001a\u00020\u0007H\u0004J\u0006\u0010u\u001a\u00020=J\u001b\u0010v\u001a\u00020=2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010@\u001a\u00028\u0000\u00a2\u0006\u0002\u0010wJ\u001b\u0010x\u001a\u00020=2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010E\u001a\u00028\u0001\u00a2\u0006\u0002\u0010wJ\u0006\u0010y\u001a\u00020=J\u0006\u0010z\u001a\u00020=J\b\u0010{\u001a\u00020|H\u0016J\u000e\u0010}\u001a\u00020=2\u0006\u0010t\u001a\u00020\u0007J\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010:R.\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00150\u00148VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0005\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001dX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0018R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010.\"\u0004\b1\u0010\bR$\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001dX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b3\u0010\u001f\"\u0004\b4\u0010!R\u001c\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u0001068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0016\u00109\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Ldorkbox/collections/ArrayMap;", "K", "", "V", "", "()V", "capacity", "", "(I)V", "ordered", "", "(ZI)V", "keyArrayType", "Ljava/lang/Class;", "valueArrayType", "(ZILjava/lang/Class;Ljava/lang/Class;)V", "(Ljava/lang/Class;Ljava/lang/Class;)V", "array", "(Ldorkbox/collections/ArrayMap;)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ArrayMap$Entries;", "entries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ArrayMap$Keys;", "keys2", "getOrdered", "()Z", "setOrdered", "(Z)V", "size", "getSize", "()I", "size_", "getSize_", "setSize_", "valueTable", "getValueTable", "setValueTable", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ArrayMap$Values;", "values2", "clear", "", "maximumCapacity", "containsAnyKey", "key", "(Ljava/lang/Object;)Z", "containsKey", "containsNullKey", "containsValue", "value", "identity", "(Ljava/lang/Object;Z)Z", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "firstKey", "()Ljava/lang/Object;", "firstValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "getKeyAt", "index", "(I)Ljava/lang/Object;", "getValueAt", "hashCode", "indexOfKey", "(Ljava/lang/Object;)I", "indexOfValue", "(Ljava/lang/Object;Z)I", "insert", "(ILjava/lang/Object;Ljava/lang/Object;)V", "isEmpty", "notEmpty", "peekKey", "peekValue", "put", "(Ljava/lang/Object;Ljava/lang/Object;I)I", "putAll", "map", "offset", "length", "from", "", "putIndex", "(Ljava/lang/Object;Ljava/lang/Object;)I", "remove", "removeIndex", "removeKey", "removeValue", "resize", "newSize", "reverse", "setKey", "(ILjava/lang/Object;)V", "setValue", "shrink", "shuffle", "toString", "", "truncate", "Companion", "Entries", "Entry", "Keys", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1147:1\n215#2,2:1148\n1#3:1150\n*S KotlinDebug\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap\n*L\n190#1:1148,2\n*E\n"})
public final class ArrayMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private K[] keyTable;
    @NotNull
    private V[] valueTable;
    private int size_;
    private boolean ordered;
    @Nullable
    private transient Entries<K, V> entries1;
    @Nullable
    private transient Entries<K, V> entries2;
    @Nullable
    private transient Values<V> values1;
    @Nullable
    private transient Values<V> values2;
    @Nullable
    private transient Keys<K> keys1;
    @Nullable
    private transient Keys<K> keys2;
    @NotNull
    public static final String version = "2.7";

    @NotNull
    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"<set-?>");
        this.keyTable = KArray;
    }

    @NotNull
    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"<set-?>");
        this.valueTable = VArray;
    }

    public final int getSize_() {
        return this.size_;
    }

    public final void setSize_(int n) {
        this.size_ = n;
    }

    public final boolean getOrdered() {
        return this.ordered;
    }

    public final void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int capacity) {
        this(true, capacity);
    }

    public ArrayMap(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.keyTable = new Object[capacity];
        this.valueTable = new Object[capacity];
    }

    public /* synthetic */ ArrayMap(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            n = 16;
        }
        this(bl, n);
    }

    public ArrayMap(boolean ordered, int capacity, @NotNull Class<K> keyArrayType, @NotNull Class<V> valueArrayType) {
        Intrinsics.checkNotNullParameter(keyArrayType, (String)"keyArrayType");
        Intrinsics.checkNotNullParameter(valueArrayType, (String)"valueArrayType");
        this.ordered = ordered;
        Object object = Array.newInstance(keyArrayType, capacity);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<K of dorkbox.collections.ArrayMap?>");
        this.keyTable = (Object[])object;
        Object object2 = Array.newInstance(valueArrayType, capacity);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<V of dorkbox.collections.ArrayMap?>");
        this.valueTable = (Object[])object2;
    }

    public ArrayMap(@NotNull Class<K> keyArrayType, @NotNull Class<V> valueArrayType) {
        Intrinsics.checkNotNullParameter(keyArrayType, (String)"keyArrayType");
        Intrinsics.checkNotNullParameter(valueArrayType, (String)"valueArrayType");
        this(false, 16, keyArrayType, valueArrayType);
    }

    public ArrayMap(@NotNull ArrayMap<K, V> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        boolean bl = array.ordered;
        int n = array.size_;
        Class<?> clazz = array.keyTable.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<K of dorkbox.collections.ArrayMap>");
        Class<?> clazz2 = array.valueTable.getClass().getComponentType();
        Intrinsics.checkNotNull(clazz2, (String)"null cannot be cast to non-null type java.lang.Class<V of dorkbox.collections.ArrayMap>");
        this(bl, n, clazz, clazz2);
        this.size_ = array.size_;
        System.arraycopy(array.keyTable, 0, this.keyTable, 0, this.size_);
        System.arraycopy(array.valueTable, 0, this.valueTable, 0, this.size_);
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @Nullable V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V oldValue = this.get(key);
        this.putIndex(key, value);
        return oldValue;
    }

    public final int putIndex(@NotNull K key, @Nullable V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.indexOfKey(key);
        if (index == -1) {
            if (this.size_ == this.keyTable.length) {
                this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
            }
            int n = this.size_;
            this.size_ = n + 1;
            index = n;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        return index;
    }

    public final int put(@NotNull K key, V value, int index) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int existingIndex = this.indexOfKey(key);
        if (existingIndex != -1) {
            this.removeIndex(existingIndex);
        } else if (this.size_ == this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
        }
        System.arraycopy(this.keyTable, index, this.keyTable, index + 1, this.size_ - index);
        System.arraycopy(this.valueTable, index, this.valueTable, index + 1, this.size_ - index);
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        int n = this.size_;
        this.size_ = n + 1;
        return index;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return this.removeKey(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Map<K, V> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> element$iv;
            Map.Entry<K, V> entry = element$iv = iterator.next();
            boolean bl = false;
            K k = entry.getKey();
            V v = entry.getValue();
            this.put(k, v);
        }
    }

    public final void putAll(@NotNull ArrayMap<? extends K, ? extends V> map, int offset, int length) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (offset + length > map.size_) {
            throw new StateException("offset + length must be <= size: " + offset + " + " + length + " <= " + map.size_);
        }
        int sizeNeeded = this.size_ + length - offset;
        if (sizeNeeded >= this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)sizeNeeded * 1.75f))));
        }
        System.arraycopy(map.keyTable, offset, this.keyTable, this.size_, length);
        System.arraycopy(map.valueTable, offset, this.valueTable, this.size_, length);
        this.size_ += length;
    }

    public static /* synthetic */ void putAll$default(ArrayMap arrayMap, ArrayMap arrayMap2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = arrayMap2.size_;
        }
        arrayMap.putAll(arrayMap2, n, n2);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        K[] keys = this.keyTable;
        for (int i = this.size_ - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual((Object)key, keys[i])) continue;
            V v = this.valueTable[i];
            Intrinsics.checkNotNull(v);
            return v;
        }
        return null;
    }

    @Nullable
    public final V get(@Nullable K key, V defaultValue) {
        int i;
        K[] keys = this.keyTable;
        if (key == null) {
            for (i = this.size_ - 1; i >= 0; --i) {
                if (keys[i] != key) continue;
                return this.valueTable[i];
            }
        } else {
            while (i >= 0) {
                if (Intrinsics.areEqual(key, keys[i])) {
                    return this.valueTable[i];
                }
                --i;
            }
        }
        return defaultValue;
    }

    @Nullable
    public final K getKey(@Nullable V value, boolean identity) {
        int i;
        V[] values = this.valueTable;
        if (identity || value == null) {
            for (i = this.size_ - 1; i >= 0; --i) {
                if (values[i] != value) continue;
                return this.keyTable[i];
            }
        } else {
            while (i >= 0) {
                if (Intrinsics.areEqual(value, values[i])) {
                    return this.keyTable[i];
                }
                --i;
            }
        }
        return null;
    }

    @Nullable
    public final K getKeyAt(int index) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.keyTable[index];
    }

    @Nullable
    public final V getValueAt(int index) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.valueTable[index];
    }

    @Nullable
    public final K firstKey() {
        if (!(this.size_ != 0)) {
            boolean bl = false;
            String string = "Map is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.keyTable[0];
    }

    @Nullable
    public final V firstValue() {
        if (!(this.size_ != 0)) {
            boolean bl = false;
            String string = "Map is empty.";
            throw new IllegalStateException(string.toString());
        }
        return this.valueTable[0];
    }

    public final void setKey(int index, @NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.keyTable[index] = key;
    }

    public final void setValue(int index, V value) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.valueTable[index] = value;
    }

    public final void insert(int index, @NotNull K key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (index > this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (this.size_ == this.keyTable.length) {
            this.resize((int)Math.max(8.0, (double)((int)((float)this.size_ * 1.75f))));
        }
        if (this.ordered) {
            System.arraycopy(this.keyTable, index, this.keyTable, index + 1, this.size_ - index);
            System.arraycopy(this.valueTable, index, this.valueTable, index + 1, this.size_ - index);
        } else {
            this.keyTable[this.size_] = this.keyTable[index];
            this.valueTable[this.size_] = this.valueTable[index];
        }
        int n = this.size_;
        this.size_ = n + 1;
        this.keyTable[index] = key;
        this.valueTable[index] = value;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        return this.containsAnyKey(key);
    }

    public final boolean containsNullKey() {
        return this.containsAnyKey(null);
    }

    private final boolean containsAnyKey(K key) {
        K[] keys = this.keyTable;
        int i = this.size_ - 1;
        if (key == null) {
            while (i >= 0) {
                if (key != keys[i--]) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!Intrinsics.areEqual(key, keys[i--])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.containsValue(value, false);
    }

    public final boolean containsValue(@Nullable V value, boolean identity) {
        V[] values = this.valueTable;
        int i = this.size_ - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (values[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!Intrinsics.areEqual(value, values[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public final int indexOfKey(@Nullable K key) {
        K[] keys = this.keyTable;
        if (key == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (keys[i] != key) continue;
                return i;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(key, keys[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public final int indexOfValue(@Nullable V value, boolean identity) {
        V[] values = this.valueTable;
        if (identity || value == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (values[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(value, values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    public final V removeKey(@Nullable K key) {
        K[] keys = this.keyTable;
        if (key == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (keys[i] != key) continue;
                V value = this.valueTable[i];
                this.removeIndex(i);
                return value;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(key, keys[i])) continue;
                V value = this.valueTable[i];
                this.removeIndex(i);
                return value;
            }
        }
        return null;
    }

    public final boolean removeValue(@Nullable V value, boolean identity) {
        V[] values = this.valueTable;
        if (identity || value == null) {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (values[i] != value) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size_;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(value, values[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public final void removeIndex(int index) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        K[] keys = this.keyTable;
        int n = this.size_;
        this.size_ = n + -1;
        if (this.ordered) {
            System.arraycopy(keys, index + 1, keys, index, this.size_ - index);
            System.arraycopy(this.valueTable, index + 1, this.valueTable, index, this.size_ - index);
        } else {
            keys[index] = keys[this.size_];
            this.valueTable[index] = this.valueTable[this.size_];
        }
        keys[this.size_] = null;
        this.valueTable[this.size_] = null;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Nullable
    public final K peekKey() {
        return this.keyTable[this.size_ - 1];
    }

    @Nullable
    public final V peekValue() {
        return this.valueTable[this.size_ - 1];
    }

    public final void clear(int maximumCapacity) {
        if (this.keyTable.length <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.resize(maximumCapacity);
    }

    public int getSize() {
        return this.size_;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keyTable, 0, this.size_, null);
        Arrays.fill(this.valueTable, 0, this.size_, null);
        this.size_ = 0;
    }

    public final void shrink() {
        if (this.keyTable.length == this.size_) {
            return;
        }
        this.resize(this.size_);
    }

    public final void ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new StateException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size_ + additionalCapacity;
        if (sizeNeeded > this.keyTable.length) {
            this.resize((int)Math.max(Math.max(8.0, (double)sizeNeeded), (double)((int)((float)this.size_ * 1.75f))));
        }
    }

    protected final void resize(int newSize) {
        Object object = Array.newInstance(this.keyTable.getClass().getComponentType(), newSize);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<K of dorkbox.collections.ArrayMap?>");
        Object[] newKeys = (Object[])object;
        System.arraycopy(this.keyTable, 0, newKeys, 0, (int)Math.min((double)this.size_, (double)newKeys.length));
        this.keyTable = newKeys;
        Object object2 = Array.newInstance(this.valueTable.getClass().getComponentType(), newSize);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<V of dorkbox.collections.ArrayMap?>");
        Object[] newValues = (Object[])object2;
        System.arraycopy(this.valueTable, 0, newValues, 0, (int)Math.min((double)this.size_, (double)newValues.length));
        this.valueTable = newValues;
    }

    public final void reverse() {
        int lastIndex = this.size_ - 1;
        int n = this.size_ / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            K tempKey = this.keyTable[i];
            this.keyTable[i] = this.keyTable[ii];
            this.keyTable[ii] = tempKey;
            V tempValue = this.valueTable[i];
            this.valueTable[i] = this.valueTable[ii];
            this.valueTable[ii] = tempValue;
        }
    }

    public final void shuffle() {
        for (int i = this.size_ - 1; -1 < i; --i) {
            int ii = Collections.INSTANCE.random(i);
            K tempKey = this.keyTable[i];
            this.keyTable[i] = this.keyTable[ii];
            this.keyTable[ii] = tempKey;
            V tempValue = this.valueTable[i];
            this.valueTable[i] = this.valueTable[ii];
            this.valueTable[ii] = tempValue;
        }
    }

    public final void truncate(int newSize) {
        if (this.size_ <= newSize) {
            return;
        }
        int n = this.size_;
        for (int i = newSize; i < n; ++i) {
            this.keyTable[i] = null;
            this.valueTable[i] = null;
        }
        this.size_ = newSize;
    }

    @Override
    public int hashCode() {
        K[] keys = this.keyTable;
        V[] values = this.valueTable;
        int h = 0;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            K key = keys[i];
            V value = values[i];
            if (key != null) {
                h += key.hashCode() * 31;
            }
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArrayMap)) {
            return false;
        }
        ArrayMap cfr_ignored_0 = (ArrayMap)other;
        if (((ArrayMap)other).size_ != this.size_) {
            return false;
        }
        K[] keys = this.keyTable;
        V[] values = this.valueTable;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            K key;
            Intrinsics.checkNotNull(keys[i], (String)"null cannot be cast to non-null type K of dorkbox.collections.ArrayMap");
            V value = values[i];
            if (!(value == null ? ((ArrayMap)other).get(key, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(value, ((ArrayMap)other).get(key)))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(@NotNull Object other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArrayMap)) {
            return false;
        }
        ArrayMap cfr_ignored_0 = (ArrayMap)other;
        if (((ArrayMap)other).size_ != this.size_) {
            return false;
        }
        K[] keys = this.keyTable;
        V[] values = this.valueTable;
        int n = this.size_;
        for (int i = 0; i < n; ++i) {
            if (values[i] == ((ArrayMap)other).get(keys[i], ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        if (this.size_ == 0) {
            return "{}";
        }
        K[] keys = this.keyTable;
        V[] values = this.valueTable;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(keys[0]);
        buffer.append('=');
        buffer.append(values[0]);
        int n = this.size_;
        for (int i = 1; i < n; ++i) {
            buffer.append(", ");
            buffer.append(keys[i]);
            buffer.append('=');
            buffer.append(values[i]);
        }
        buffer.append('}');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        Entries<K, V> entries = this.entries();
        Intrinsics.checkNotNull(entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<K of dorkbox.collections.ArrayMap, V of dorkbox.collections.ArrayMap?>>");
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keys();
    }

    @NotNull
    public Collection<V> getValues() {
        return this.values();
    }

    @NotNull
    public final Entries<K, V> entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<K of dorkbox.collections.ArrayMap, V of dorkbox.collections.ArrayMap?>");
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<K of dorkbox.collections.ArrayMap, V of dorkbox.collections.ArrayMap?>");
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K, V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid$Collections()) {
            Entries<K, V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.setIndex$Collections(0);
            Entries<K, V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid$Collections(true);
            Entries<K, V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid$Collections(false);
            Entries<K, V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap.Entries<K of dorkbox.collections.ArrayMap, V of dorkbox.collections.ArrayMap?>");
            return entries5;
        }
        Entries<K, V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.setIndex$Collections(0);
        Entries<K, V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid$Collections(true);
        Entries<K, V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid$Collections(false);
        Entries<K, V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap.Entries<K of dorkbox.collections.ArrayMap, V of dorkbox.collections.ArrayMap?>");
        return entries9;
    }

    @Override
    @NotNull
    public final Values<V> values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<kotlin.Any, V of dorkbox.collections.ArrayMap?>");
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<kotlin.Any, V of dorkbox.collections.ArrayMap?>");
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.setIndex(0);
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap.Values<V of dorkbox.collections.ArrayMap?>");
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.setIndex(0);
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap.Values<V of dorkbox.collections.ArrayMap?>");
        return values9;
    }

    @NotNull
    public final Keys<K> keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<K of dorkbox.collections.ArrayMap, kotlin.Any>");
            return new Keys(this);
        }
        if (this.keys1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.ArrayMap<K of dorkbox.collections.ArrayMap, kotlin.Any>");
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.setIndex(0);
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.setIndex(0);
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/ArrayMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u00042\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u00050\u0006B\u001b\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0019\u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010\u001b\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001f\u0010 \u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J$\u0010!\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\t\u0010\"\u001a\u00020\u0014H\u0096\u0002J\b\u0010#\u001a\u00020\u0014H\u0016J\u001d\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u0006H\u0096\u0002J\u0017\u0010%\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0096\u0002J\b\u0010&\u001a\u00020\u001fH\u0016J\u001e\u0010&\u001a\u00020\u00142\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0005H\u0016J$\u0010'\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016J\u0006\u0010(\u001a\u00020\u001fJ$\u0010)\u001a\u00020\u00142\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u00050\u001dH\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Ldorkbox/collections/ArrayMap$Entries;", "K", "", "V", "", "Ldorkbox/collections/ArrayMap$Entry;", "", "map", "Ldorkbox/collections/ArrayMap;", "(Ldorkbox/collections/ArrayMap;)V", "entry", "index", "", "getIndex$Collections", "()I", "setIndex$Collections", "(I)V", "size", "getSize", "valid", "", "getValid$Collections", "()Z", "setValid$Collections", "(Z)V", "add", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "reset", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1147:1\n1855#2,2:1148\n1855#2,2:1150\n288#2,2:1153\n1855#2,2:1156\n13309#3:1152\n13310#3:1155\n*S KotlinDebug\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Entries\n*L\n812#1:1148,2\n832#1:1150,2\n852#1:1153,2\n864#1:1156,2\n850#1:1152\n850#1:1155\n*E\n"})
    public static final class Entries<K, V>
    implements Set<Entry<K, V>>,
    Iterator<Entry<K, V>>,
    KMutableSet,
    KMutableIterator {
        @NotNull
        private final ArrayMap<K, V> map;
        @Nullable
        private Entry<K, V> entry;
        private int index;
        private boolean valid;

        public Entries(@NotNull ArrayMap<K, V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.valid = true;
        }

        public final int getIndex$Collections() {
            return this.index;
        }

        public final void setIndex$Collections(int n) {
            this.index = n;
        }

        public final boolean getValid$Collections() {
            return this.valid;
        }

        public final void setValid$Collections(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        @Override
        public boolean add(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.map.put(element.getKey(), element.getValue());
            this.reset();
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry<K, V>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                this.map.put(k, v);
                added = true;
            }
            this.reset();
            return added;
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.map.get(k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return Intrinsics.areEqual(this.map.get(element.getKey()), element.getValue());
        }

        @Override
        @NotNull
        public Iterator<Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.map.getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v0;
                K key;
                block2: {
                    K element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == null) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getKey(), key)) continue;
                        v0 = element$iv2;
                        break block2;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) continue;
                removed = this.map.remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                Object v = ((Map.Entry)entry).getValue();
                if (!Intrinsics.areEqual(this.map.get(k), v)) continue;
                this.map.removeKey(k);
                removed = true;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry<K, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            if (Intrinsics.areEqual(this.map.get(element.getKey()), element.getValue())) {
                this.map.removeKey(element.getKey());
                return true;
            }
            this.reset();
            return false;
        }

        @Override
        @NotNull
        public Entry<K, V> next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.entry == null) {
                K k = this.map.getKeyTable()[this.index];
                Intrinsics.checkNotNull(k);
                int n = this.index;
                this.index = n + 1;
                this.entry = new Entry<K, V>(k, this.map.getValueTable()[n], this.map);
            } else {
                Entry<K, V> entry = this.entry;
                Intrinsics.checkNotNull(entry);
                K k = this.map.getKeyTable()[this.index];
                Intrinsics.checkNotNull(k);
                entry.setKey(k);
                Entry<K, V> entry2 = this.entry;
                Intrinsics.checkNotNull(entry2);
                int n = this.index;
                this.index = n + 1;
                entry2.setValue(this.map.getValueTable()[n]);
            }
            Entry<K, V> entry = this.entry;
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\u0004\b\u0003\u0010\u00032\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00030\u0004B)\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0006\u001a\u00028\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u0012\u001a\u0004\u0018\u00018\u00032\b\u0010\u0013\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0005\u001a\u00028\u0002X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0003X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/ArrayMap$Entry;", "K", "", "V", "", "key", "value", "map", "Ldorkbox/collections/ArrayMap;", "(Ljava/lang/Object;Ljava/lang/Object;Ldorkbox/collections/ArrayMap;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ArrayMap;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        @NotNull
        private final ArrayMap<K, V> map;
        @NotNull
        private K key;
        @Nullable
        private V value;

        public Entry(@NotNull K key, V value, @NotNull ArrayMap<K, V> map) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final ArrayMap<K, V> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public K getKey() {
            return this.key;
        }

        public void setKey(@NotNull K k) {
            Intrinsics.checkNotNullParameter(k, (String)"<set-?>");
            this.key = k;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable V v) {
            this.value = v;
        }

        @Override
        @Nullable
        public V setValue(@Nullable V newValue) {
            V oldValue = this.getValue();
            ((Map)this.map).put(this.getKey(), newValue);
            this.setValue(newValue);
            return oldValue;
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\t\u0010 \u001a\u00020\u0011H\u0096\u0002J\b\u0010!\u001a\u00020\u0011H\u0016J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004H\u0096\u0002J\u000e\u0010#\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001dH\u0016J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u0006\u0010'\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020*J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020*R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Ldorkbox/collections/ArrayMap$Keys;", "K", "", "", "", "map", "Ldorkbox/collections/ArrayMap;", "(Ldorkbox/collections/ArrayMap;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "size", "getSize", "valid", "", "getValid", "()Z", "setValid", "(Z)V", "add", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "reset", "retainAll", "toArray", "Ldorkbox/collections/ExpandingArray;", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1147:1\n1855#2,2:1148\n1855#2,2:1152\n13309#3,2:1150\n*S KotlinDebug\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Keys\n*L\n1075#1:1148,2\n1105#1:1152,2\n1093#1:1150,2\n*E\n"})
    public static final class Keys<K>
    implements Set<K>,
    Iterator<K>,
    KMutableSet,
    KMutableIterator {
        @NotNull
        private final ArrayMap<K, Object> map;
        private int index;
        private boolean valid;

        public Keys(@NotNull ArrayMap<K, Object> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.valid = true;
            this.map = map;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        @Override
        public boolean add(@NotNull K element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.map.getSize_() == 0;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.map.containsKey(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            return this.map.containsKey(element);
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.map.getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                K element$iv;
                K it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (it == null || elements.contains(it)) continue;
                this.map.remove(it);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.map.remove(it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            boolean removed = this.map.remove(element) == null;
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public K next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            K k = this.map.getKeyTable()[n];
            Intrinsics.checkNotNull(k);
            return k;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @NotNull
        public final ExpandingArray<K> toArray() {
            return new ExpandingArray<K>(true, this.map.getKeyTable(), this.index, this.map.getSize_() - this.index);
        }

        @NotNull
        public final ExpandingArray<K> toArray(@NotNull ExpandingArray<K> array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            array.addAll(this.map.getKeyTable(), this.index, this.map.getSize_() - this.index);
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\t\u0010 \u001a\u00020\u0011H\u0096\u0002J\b\u0010!\u001a\u00020\u0011H\u0016J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003H\u0096\u0002J\u000e\u0010#\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u001dH\u0016J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\u0006\u0010'\u001a\u00020\u001dJ\u0016\u0010(\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u001bH\u0016J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00020*R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Ldorkbox/collections/ArrayMap$Values;", "V", "", "", "map", "Ldorkbox/collections/ArrayMap;", "", "(Ldorkbox/collections/ArrayMap;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "size", "getSize", "valid", "", "getValid", "()Z", "setValid", "(Z)V", "add", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "reset", "retainAll", "toArray", "Ldorkbox/collections/ExpandingArray;", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1147:1\n1855#2,2:1148\n1855#2,2:1152\n13309#3,2:1150\n*S KotlinDebug\n*F\n+ 1 ArrayMap.kt\ndorkbox/collections/ArrayMap$Values\n*L\n959#1:1148,2\n992#1:1152,2\n977#1:1150,2\n*E\n"})
    public static final class Values<V>
    implements Collection<V>,
    Iterator<V>,
    KMutableCollection,
    KMutableIterator {
        @NotNull
        private final ArrayMap<Object, V> map;
        private int index;
        private boolean valid;

        public Values(@NotNull ArrayMap<Object, V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.valid = true;
            this.map = map;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.getSize_();
        }

        public int getSize() {
            return this.map.getSize_();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.map.getSize_() == 0;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.map.containsValue(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object element) {
            return this.map.containsValue(element);
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Object[] $this$forEach$iv = this.map.getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                V value;
                Object element$iv;
                Object key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == null || CollectionsKt.contains((Iterable)elements, value = this.map.get(key))) continue;
                this.map.remove(key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object key = this.map.getKey(it, false);
                if (key == null) continue;
                removed = this.map.remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(Object element) {
            boolean removed = false;
            Object key = this.map.getKey(element, false);
            if (key != null) {
                removed = this.map.remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @Override
        public V next() {
            if (this.index >= this.map.getSize_()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.index;
            this.index = n + 1;
            V v = this.map.getValueTable()[n];
            Intrinsics.checkNotNull(v);
            return v;
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.map.removeIndex(this.index);
        }

        public final void reset() {
            this.index = 0;
        }

        @NotNull
        public final ExpandingArray<V> toArray() {
            return new ExpandingArray<V>(true, this.map.getValueTable(), this.index, this.map.getSize_() - this.index);
        }

        @NotNull
        public final ExpandingArray<V> toArray(@NotNull ExpandingArray<V> array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            array.addAll(this.map.getValueTable(), this.index, this.map.getSize_() - this.index);
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

