/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 -*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003:\u0002-.B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001b\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0006\u0010#\u001a\u00020\u0007J\r\u0010$\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\u0013\u0010'\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010(\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Ldorkbox/collections/BinaryHeap;", "T", "Ldorkbox/collections/BinaryHeap$Node;", "", "capacity", "", "isMaxHeap", "", "(IZ)V", "isEmpty", "()Z", "nodes", "", "[Ldorkbox/collections/BinaryHeap$Node;", "size", "getSize", "()I", "setSize", "(I)V", "add", "node", "(Ldorkbox/collections/BinaryHeap$Node;)Ldorkbox/collections/BinaryHeap$Node;", "value", "", "(Ldorkbox/collections/BinaryHeap$Node;F)Ldorkbox/collections/BinaryHeap$Node;", "clear", "", "contains", "identity", "(Ldorkbox/collections/BinaryHeap$Node;Z)Z", "down", "index", "equals", "other", "hashCode", "notEmpty", "peek", "()Ldorkbox/collections/BinaryHeap$Node;", "pop", "remove", "setValue", "(Ldorkbox/collections/BinaryHeap$Node;F)V", "toString", "", "up", "Companion", "Node", "Collections"})
@SourceDebugExtension(value={"SMAP\nBinaryHeap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryHeap.kt\ndorkbox/collections/BinaryHeap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class BinaryHeap<T extends Node> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isMaxHeap;
    private int size;
    @NotNull
    private Node[] nodes;
    @NotNull
    public static final String version = "2.7";

    @JvmOverloads
    public BinaryHeap(int capacity, boolean isMaxHeap) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[capacity];
    }

    public /* synthetic */ BinaryHeap(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final T add(T node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        T t = node;
        Intrinsics.checkNotNull(t);
        ((Node)t).setIndex(this.size);
        this.nodes[this.size] = node;
        int n = this.size;
        this.size = n + 1;
        this.up(n);
        return node;
    }

    public final T add(T node, float value) {
        T t = node;
        Intrinsics.checkNotNull(t);
        ((Node)t).setValue(value);
        return this.add(node);
    }

    public final boolean contains(@Nullable T node, boolean identity) {
        if (node == null) {
            boolean bl = false;
            String string = "node cannot be null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (identity) {
            for (Node n : this.nodes) {
                if (n != node) continue;
                return true;
            }
        } else {
            for (Node other : this.nodes) {
                if (!Intrinsics.areEqual((Object)other, node)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final T peek() {
        if (!(this.size != 0)) {
            boolean bl = false;
            String string = "The heap is empty.";
            throw new IllegalStateException(string.toString());
        }
        return (T)this.nodes[0];
    }

    @Nullable
    public final T pop() {
        Node removed = this.nodes[0];
        this.size += -1;
        if (this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return (T)removed;
    }

    public final T remove(T node) {
        this.size += -1;
        if (this.size > 0) {
            Node moved = this.nodes[this.size];
            this.nodes[this.size] = null;
            T t = node;
            Intrinsics.checkNotNull(t);
            this.nodes[((Node)t).getIndex()] = moved;
            Node node2 = moved;
            Intrinsics.checkNotNull((Object)node2);
            if (node2.getValue() < ((Node)node).getValue() ^ this.isMaxHeap) {
                this.up(((Node)node).getIndex());
            } else {
                this.down(((Node)node).getIndex());
            }
        } else {
            this.nodes[0] = null;
        }
        return node;
    }

    public final boolean notEmpty() {
        return this.size > 0;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        Arrays.fill(this.nodes, 0, this.size, null);
        this.size = 0;
    }

    public final void setValue(T node, float value) {
        T t = node;
        Intrinsics.checkNotNull(t);
        float oldValue = ((Node)t).getValue();
        ((Node)node).setValue(value);
        if (value < oldValue ^ this.isMaxHeap) {
            this.up(((Node)node).getIndex());
        } else {
            this.down(((Node)node).getIndex());
        }
    }

    private final void up(int index) {
        Node node;
        int index2 = index;
        Node[] nodes = this.nodes;
        Node node2 = node = nodes[index2];
        Intrinsics.checkNotNull((Object)node2);
        float value = node2.getValue();
        while (index2 > 0) {
            Node parent;
            int parentIndex = index2 - 1 >> 1;
            Node node3 = parent = nodes[parentIndex];
            Intrinsics.checkNotNull((Object)node3);
            if (!(value < node3.getValue() ^ this.isMaxHeap)) break;
            nodes[index2] = parent;
            parent.setIndex(index2);
            index2 = parentIndex;
        }
        nodes[index2] = node;
        node.setIndex(index2);
    }

    private final void down(int index) {
        int leftIndex;
        Node node;
        int index2 = index;
        Node[] nodes = this.nodes;
        int size = this.size;
        Node node2 = node = nodes[index2];
        Intrinsics.checkNotNull((Object)node2);
        float value = node2.getValue();
        while ((leftIndex = 1 + (index2 << 1)) < size) {
            Node leftNode;
            int rightIndex = leftIndex + 1;
            Node node3 = leftNode = nodes[leftIndex];
            Intrinsics.checkNotNull((Object)node3);
            float leftValue = node3.getValue();
            Node rightNode = null;
            float rightValue = 0.0f;
            if (rightIndex >= size) {
                rightNode = null;
                rightValue = this.isMaxHeap ? -3.4028235E38f : Float.MAX_VALUE;
            } else {
                Node node4 = rightNode = nodes[rightIndex];
                Intrinsics.checkNotNull((Object)node4);
                rightValue = node4.getValue();
            }
            if (leftValue < rightValue ^ this.isMaxHeap) {
                if (leftValue == value || leftValue > value ^ this.isMaxHeap) break;
                nodes[index2] = leftNode;
                leftNode.setIndex(index2);
                index2 = leftIndex;
                continue;
            }
            if (rightValue == value || rightValue > value ^ this.isMaxHeap) break;
            nodes[index2] = rightNode;
            if (rightNode != null) {
                rightNode.setIndex(index2);
            }
            index2 = rightIndex;
        }
        nodes[index2] = node;
        node.setIndex(index2);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BinaryHeap)) {
            return false;
        }
        if (((BinaryHeap)other).size != this.size) {
            return false;
        }
        Node[] nodes1 = this.nodes;
        Node[] nodes2 = ((BinaryHeap)other).nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes1[i];
            Intrinsics.checkNotNull((Object)node);
            float f = node.getValue();
            Node node2 = nodes2[i];
            Intrinsics.checkNotNull((Object)node2);
            if (f == node2.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        Node[] nodes = this.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodes[i];
            Intrinsics.checkNotNull((Object)node);
            h = h * 31 + Float.floatToIntBits(node.getValue());
        }
        return h;
    }

    @NotNull
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodes = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        Node node = nodes[0];
        Intrinsics.checkNotNull((Object)node);
        buffer.append(node.getValue());
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            buffer.append(", ");
            Node node2 = nodes[i];
            Intrinsics.checkNotNull((Object)node2);
            buffer.append(node2.getValue());
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public BinaryHeap(int capacity) {
        this(capacity, false, 2, null);
    }

    @JvmOverloads
    public BinaryHeap() {
        this(0, false, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/BinaryHeap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0004\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/BinaryHeap$Node;", "", "value", "", "(F)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getValue", "()F", "setValue", "toString", "", "Collections"})
    public static class Node {
        private float value;
        private int index;

        public Node(float value) {
            this.value = value;
        }

        public final float getValue() {
            return this.value;
        }

        public final void setValue(float f) {
            this.value = f;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

