/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Bias;
import dorkbox.collections.StateException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004\u0019\u001a\u001b\u001cB#\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldorkbox/collections/BinarySearch;", "T", "", "eval", "Ldorkbox/collections/BinarySearch$Evaluator;", "l", "", "(Ldorkbox/collections/BinarySearch$Evaluator;Ljava/util/List;)V", "indexed", "Ldorkbox/collections/BinarySearch$Indexed;", "(Ldorkbox/collections/BinarySearch$Evaluator;Ldorkbox/collections/BinarySearch$Indexed;)V", "checkSorted", "", "match", "prototype", "bias", "Ldorkbox/collections/Bias;", "(Ljava/lang/Object;Ldorkbox/collections/Bias;)Ljava/lang/Object;", "search", "", "value", "start", "end", "searchFor", "(JLdorkbox/collections/Bias;)Ljava/lang/Object;", "Companion", "Evaluator", "Indexed", "ListWrap", "Collections"})
public final class BinarySearch<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Evaluator<T> eval;
    @NotNull
    private final Indexed<T> indexed;
    @NotNull
    public static final String version = "2.7";

    public BinarySearch(@NotNull Evaluator<T> eval, @NotNull Indexed<T> indexed) {
        Intrinsics.checkNotNullParameter(eval, (String)"eval");
        Intrinsics.checkNotNullParameter(indexed, (String)"indexed");
        this.eval = eval;
        this.indexed = indexed;
        boolean bl = this.checkSorted();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public BinarySearch(@NotNull Evaluator<T> eval, @NotNull List<? extends T> l) {
        Intrinsics.checkNotNullParameter(eval, (String)"eval");
        Intrinsics.checkNotNullParameter(l, (String)"l");
        this(eval, new ListWrap<T>(l));
    }

    private final boolean checkSorted() {
        long val = Long.MIN_VALUE;
        long sz = this.indexed.size();
        for (long i = 0L; i < sz; ++i) {
            T t = this.indexed.get(i);
            long nue = this.eval.getValue(t);
            if (val != Long.MIN_VALUE && nue < val) {
                throw new StateException("Collection is not sorted at " + i + " - " + this.indexed);
            }
            val = nue;
        }
        return true;
    }

    public final long search(long value, @NotNull Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"bias");
        return this.search(0L, this.indexed.size() - 1L, value, bias);
    }

    @Nullable
    public final T match(T prototype, @NotNull Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"bias");
        long value = this.eval.getValue(prototype);
        long index = this.search(value, bias);
        return index == -1L ? null : (T)this.indexed.get(index);
    }

    @Nullable
    public final T searchFor(long value, @NotNull Bias bias) {
        Intrinsics.checkNotNullParameter((Object)((Object)bias), (String)"bias");
        long index = this.search(value, bias);
        return index == -1L ? null : (T)this.indexed.get(index);
    }

    private final long search(long start, long end, long value, Bias bias) {
        long range = end - start;
        if (range == 0L) {
            return start;
        }
        if (range == 1L) {
            long l;
            T ahead = this.indexed.get(end);
            T behind = this.indexed.get(start);
            long v1 = this.eval.getValue(behind);
            long v2 = this.eval.getValue(ahead);
            switch (WhenMappings.$EnumSwitchMapping$0[bias.ordinal()]) {
                case 1: {
                    l = start;
                    break;
                }
                case 2: {
                    l = end;
                    break;
                }
                case 3: {
                    if (v1 == value) {
                        l = start;
                        break;
                    }
                    if (v2 == value) {
                        l = end;
                        break;
                    }
                    if (Math.abs((double)(v1 - value)) < Math.abs((double)(v2 - value))) {
                        l = start;
                        break;
                    }
                    l = end;
                    break;
                }
                case 4: {
                    if (v1 == value) {
                        l = start;
                        break;
                    }
                    if (v2 == value) {
                        l = end;
                        break;
                    }
                    l = -1L;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }
        long mid = start + range / (long)2;
        long vm = this.eval.getValue(this.indexed.get(mid));
        return value >= vm ? this.search(mid, end, value, bias) : this.search(start, mid, value, bias);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/BinarySearch$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldorkbox/collections/BinarySearch$Evaluator;", "T", "", "getValue", "", "obj", "(Ljava/lang/Object;)J", "Collections"})
    public static interface Evaluator<T> {
        public long getValue(T var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0016\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Ldorkbox/collections/BinarySearch$Indexed;", "T", "", "get", "index", "", "(J)Ljava/lang/Object;", "size", "Collections"})
    public static interface Indexed<T> {
        public T get(long var1);

        public long size();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldorkbox/collections/BinarySearch$ListWrap;", "T", "Ldorkbox/collections/BinarySearch$Indexed;", "l", "", "(Ljava/util/List;)V", "get", "index", "", "(J)Ljava/lang/Object;", "size", "toString", "", "Collections"})
    private static final class ListWrap<T>
    implements Indexed<T> {
        @NotNull
        private final List<T> l;

        public ListWrap(@NotNull List<? extends T> l) {
            Intrinsics.checkNotNullParameter(l, (String)"l");
            this.l = l;
        }

        @Override
        public T get(long index) {
            return this.l.get((int)index);
        }

        @Override
        public long size() {
            return this.l.size();
        }

        @NotNull
        public String toString() {
            return super.toString() + '{' + this.l + '}';
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bias.values().length];
            try {
                nArray[Bias.BACKWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bias.FORWARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bias.NEAREST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bias.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

