/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.IdentityMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class IdentitySet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private transient IdentityMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public IdentitySet() {
        this.map = new IdentityMap();
    }

    public IdentitySet(Collection<? extends E> c) {
        this.map = new IdentityMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public IdentitySet(int initialCapacity) {
        this.map = new IdentityMap(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

