/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 L2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002LMB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0014J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002J\u0016\u0010'\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020\u0002H\u0002J\b\u00100\u001a\u00020(H\u0016J\u000e\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u0002J\u0011\u00102\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0002H\u0096\u0002J\u0016\u00103\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0016J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u0002J\u0013\u00106\u001a\u00020\u000b2\b\u00107\u001a\u0004\u0018\u000108H\u0096\u0002J\u0006\u00109\u001a\u00020\u0002J\u0018\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u0010/\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020\u0002H\u0016J\b\u0010=\u001a\u00020\u000bH\u0016J\t\u0010>\u001a\u00020\u0011H\u0096\u0002J\u0010\u0010?\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0002H\u0002J\u0006\u0010@\u001a\u00020\u000bJ\u0010\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020\u0002H\u0004J\u0015\u0010C\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010DJ\u0016\u0010E\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0016J\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020\u0002H\u0002J\u0016\u0010H\u001a\u00020\u000b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020-H\u0016J\u000e\u0010I\u001a\u00020(2\u0006\u00101\u001a\u00020\u0002J\b\u0010J\u001a\u00020KH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0014\u0010!\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001bR\u000e\u0010#\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Ldorkbox/collections/IntSet;", "", "", "()V", "initialCapacity", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/IntSet;)V", "hasZeroValue", "", "getHasZeroValue", "()Z", "setHasZeroValue", "(Z)V", "iterator1", "Ldorkbox/collections/IntSet$IntSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "add", "element", "addAll", "", "array", "offset", "length", "elements", "", "addResize", "key", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "", "first", "get", "(I)Ljava/lang/Integer;", "hashCode", "isEmpty", "iterator", "locateKey", "notEmpty", "place", "item", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "Companion", "IntSetIterator", "Collections"})
@SourceDebugExtension(value={"SMAP\nIntSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntSet.kt\ndorkbox/collections/IntSet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,584:1\n1855#2,2:585\n1855#2,2:588\n1855#2,2:592\n1#3:587\n13330#4,2:590\n*S KotlinDebug\n*F\n+ 1 IntSet.kt\ndorkbox/collections/IntSet\n*L\n195#1:585,2\n326#1:588,2\n476#1:592,2\n465#1:590,2\n*E\n"})
public final class IntSet
implements Set<Integer>,
KMutableSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    @NotNull
    private int[] keyTable;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient IntSetIterator iterator1;
    @Nullable
    private transient IntSetIterator iterator2;
    @NotNull
    public static final String version = "2.7";

    @NotNull
    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.keyTable = nArray;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntSet() {
        this(51, 0.8f);
    }

    public IntSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[tableSize];
    }

    public /* synthetic */ IntSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntSet(@NotNull IntSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this((int)((float)set.keyTable.length * set.loadFactor), set.loadFactor);
        System.arraycopy(set.keyTable, 0, this.keyTable, 0, set.keyTable.length);
        this.size_ = set.size_;
        this.hasZeroValue = set.hasZeroValue;
    }

    public int getSize() {
        return this.size_;
    }

    protected final int place(int item) {
        return (int)((long)item * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        int other;
        while ((other = keyTable[i]) != 0) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Nullable
    public final Integer get(int key) {
        int i = this.locateKey(key);
        return i < 0 ? null : Integer.valueOf(this.keyTable[i]);
    }

    @Override
    public boolean add(int element) {
        if (element == 0) {
            if (this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = true;
            int n = this.size_;
            this.size_ = n + 1;
            return true;
        }
        int i = this.locateKey(element);
        if (i >= 0) {
            return false;
        }
        i = -(i + 1);
        this.keyTable[i] = element;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean added = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            added = this.add(it) || added;
        }
        return added;
    }

    public final void addAll(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.addAll(array, 0, array.length);
    }

    public final void addAll(@NotNull int[] array, int offset, int length) {
        int i;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (offset + length > array.length) {
            throw new StateException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.length);
        }
        this.ensureCapacity(length);
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
    }

    public final void addAll(@NotNull IntSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this.ensureCapacity(set.size_);
        if (set.hasZeroValue) {
            this.add(0);
        }
        for (int key : set.keyTable) {
            if (key == 0) continue;
            this.add(key);
        }
    }

    private final void addResize(int key) {
        int[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public boolean remove(@Nullable Integer element) {
        int n;
        if (element == 0) {
            if (!this.hasZeroValue) {
                return false;
            }
            this.hasZeroValue = false;
            int n2 = this.size_;
            this.size_ = n2 + -1;
            return true;
        }
        int i = this.locateKey(element);
        if (i < 0) {
            return false;
        }
        int[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        int k = 0;
        while (true) {
            int it = n = keyTable[next];
            boolean bl = false;
            k = it;
            if (n == 0) break;
            int placement = this.place(k);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0;
        n = this.size_;
        this.size_ = n + -1;
        return true;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public final void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public final void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            if (this.contains((Object)it)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int element) {
        return element == 0 ? this.hasZeroValue : this.locateKey(element) >= 0;
    }

    public final int first() {
        if (this.hasZeroValue) {
            return 0;
        }
        int[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("IntSet is empty.");
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.size_ + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] oldKeyTable = this.keyTable;
        this.keyTable = new int[newSize];
        if (this.size_ > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.addResize(key);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size_;
        for (int key : this.keyTable) {
            if (key == 0) continue;
            h += key;
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof IntSet)) {
            return false;
        }
        if (((IntSet)other).size_ != this.size_) {
            return false;
        }
        if (((IntSet)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        int[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == 0 || ((IntSet)other).contains((Object)keyTable[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        int key;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0");
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0) continue;
                buffer.append(key);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public IntSetIterator iterator() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new IntSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new IntSetIterator(this);
            this.iterator2 = new IntSetIterator(this);
        }
        IntSetIterator intSetIterator = this.iterator1;
        Intrinsics.checkNotNull((Object)intSetIterator);
        if (!intSetIterator.getValid()) {
            IntSetIterator intSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator2);
            intSetIterator2.reset();
            IntSetIterator intSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator3);
            intSetIterator3.setValid(true);
            IntSetIterator intSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull((Object)intSetIterator4);
            intSetIterator4.setValid(false);
            IntSetIterator intSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull((Object)intSetIterator5);
            return intSetIterator5;
        }
        IntSetIterator intSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator6);
        intSetIterator6.reset();
        IntSetIterator intSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator7);
        intSetIterator7.setValid(true);
        IntSetIterator intSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull((Object)intSetIterator8);
        intSetIterator8.setValid(false);
        IntSetIterator intSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull((Object)intSetIterator9);
        return intSetIterator9;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        int[] $this$forEach$iv = this.keyTable;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (elements.contains(it)) continue;
            this.remove((Object)it);
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            removed = this.remove((Object)it) || removed;
        }
        return removed;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldorkbox/collections/IntSet$Companion;", "", "()V", "version", "", "with", "Ldorkbox/collections/IntSet;", "array", "", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntSet with(int ... array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            IntSet set = new IntSet();
            set.addAll(array);
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u000e\u0010\u001b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u001a\u0010\u0006\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010\u00a8\u0006#"}, d2={"Ldorkbox/collections/IntSet$IntSetIterator;", "", "", "set", "Ldorkbox/collections/IntSet;", "(Ldorkbox/collections/IntSet;)V", "currentIndex", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/IntSet;", "valid", "getValid", "setValid", "findNextIndex", "", "next", "()Ljava/lang/Integer;", "remove", "reset", "toArray", "", "array", "Companion", "Collections"})
    @SourceDebugExtension(value={"SMAP\nIntSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntSet.kt\ndorkbox/collections/IntSet$IntSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1#2:585\n*E\n"})
    public static final class IntSetIterator
    implements Iterator<Integer>,
    KMutableIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IntSet set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        private static final int INDEX_ZERO = -1;

        public IntSetIterator(@NotNull IntSet set) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            this.set = set;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final IntSet getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.set.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                int[] keyTable = this.set.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.set.getHasZeroValue()) {
                this.set.setHasZeroValue(false);
            } else {
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                int[] keyTable = this.set.getKeyTable();
                int mask = this.set.getMask();
                int next = i + 1 & mask;
                int key = 0;
                while (true) {
                    int n;
                    int it = n = keyTable[next];
                    boolean bl = false;
                    key = it;
                    if (n == 0) break;
                    int placement = this.set.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0;
                if (i != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                IntSet intSet = this.set;
                int n = intSet.size_;
                intSet.size_ = n + -1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        @NotNull
        public Integer next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.nextIndex == -1 ? 0 : this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.set.size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @NotNull
        public final int[] toArray(@NotNull int[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.hasNext) {
                array[index++] = this.next();
            }
            return array;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntSet$IntSetIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

