/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.IntMap;
import dorkbox.collections.LockFreeObjectIntBiMap;
import dorkbox.collections.ObjectIntMap;
import dorkbox.collections.StateException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 ;*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00052\u00020\u0006:\u0001;B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB9\b\u0010\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0004H\u0016J\u0015\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010,J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\b\u0010-\u001a\u00020$H\u0016J\u001f\u0010.\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\"2\u0014\u00101\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u000002H\u0016J\u001a\u00103\u001a\u00020\"2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u000002J\u001d\u00105\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0017\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010*J\u001c\u00107\u001a\u00020\"2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u000102J\u001c\u00108\u001a\u00020\"2\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u000102J\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\rR\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006<"}, d2={"Ldorkbox/collections/LockFreeIntBiMap;", "V", "", "", "", "", "Ljava/io/Serializable;", "()V", "defaultReturnValue", "(I)V", "forwardHashMap", "Ldorkbox/collections/IntMap;", "reverseHashMap", "Ldorkbox/collections/ObjectIntMap;", "inverse", "Ldorkbox/collections/LockFreeObjectIntBiMap;", "(Ldorkbox/collections/IntMap;Ldorkbox/collections/ObjectIntMap;Ldorkbox/collections/LockFreeObjectIntBiMap;I)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "reverseValues", "", "getReverseValues", "()Ljava/util/Collection;", "size", "getSize", "()I", "values", "getValues", "clear", "", "containsKey", "", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "get", "(I)Ljava/lang/Object;", "getReverse", "(Ljava/lang/Object;)Ljava/lang/Integer;", "isEmpty", "put", "(ILjava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "putAllForce", "hashMap", "putForce", "remove", "replaceAll", "replaceAllForce", "toMap", "toReverseMap", "Companion", "Collections"})
public final class LockFreeIntBiMap<V>
implements Map<Integer, V>,
Cloneable,
Serializable,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int defaultReturnValue;
    @NotNull
    private volatile IntMap<V> forwardHashMap;
    @NotNull
    private volatile ObjectIntMap<V> reverseHashMap;
    @NotNull
    private final LockFreeObjectIntBiMap<V> inverse;
    @NotNull
    public static final String version = "2.7";
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap<?>, IntMap<?>> forwardREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, IntMap.class, "forwardHashMap");
    private static final AtomicReferenceFieldUpdater<LockFreeIntBiMap<?>, ObjectIntMap<?>> reverseREF = AtomicReferenceFieldUpdater.newUpdater(LockFreeIntBiMap.class, ObjectIntMap.class, "reverseHashMap");

    public LockFreeIntBiMap() {
        this(Integer.MIN_VALUE);
    }

    public LockFreeIntBiMap(int defaultReturnValue) {
        this.forwardHashMap = new IntMap();
        this.reverseHashMap = new ObjectIntMap();
        this.inverse = new LockFreeObjectIntBiMap<V>(this.reverseHashMap, this.forwardHashMap, this, defaultReturnValue);
        this.defaultReturnValue = defaultReturnValue;
    }

    public LockFreeIntBiMap(@NotNull IntMap<V> forwardHashMap, @NotNull ObjectIntMap<V> reverseHashMap, @NotNull LockFreeObjectIntBiMap<V> inverse, int defaultReturnValue) {
        Intrinsics.checkNotNullParameter(forwardHashMap, (String)"forwardHashMap");
        Intrinsics.checkNotNullParameter(reverseHashMap, (String)"reverseHashMap");
        Intrinsics.checkNotNullParameter(inverse, (String)"inverse");
        this.forwardHashMap = forwardHashMap;
        this.reverseHashMap = reverseHashMap;
        this.inverse = inverse;
        this.defaultReturnValue = defaultReturnValue;
    }

    public int getSize() {
        return this.forwardHashMap.size();
    }

    @Override
    public synchronized void clear() {
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        IntMap<?> intMap = forwardREF.get(this);
        Intrinsics.checkNotNullExpressionValue(intMap, (String)"get(...)");
        return ((Map)intMap).containsValue(value);
    }

    public boolean containsKey(int key) {
        return forwardREF.get(this).containsKey((Object)key);
    }

    @NotNull
    public final LockFreeObjectIntBiMap<V> inverse() {
        return this.inverse;
    }

    public final synchronized void replaceAll(@Nullable Map<Integer, ? extends V> hashMap) throws StateException {
        if (hashMap == null) {
            throw new NullPointerException("hashMap");
        }
        LockFreeIntBiMap<? extends V> biMap = new LockFreeIntBiMap<V>();
        biMap.putAll(hashMap);
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public final synchronized void replaceAllForce(@Nullable Map<Integer, ? extends V> hashMap) {
        if (hashMap == null) {
            throw new NullPointerException("hashMap");
        }
        this.forwardHashMap.clear();
        this.reverseHashMap.clear();
        this.putAllForce(hashMap);
    }

    @Override
    @Nullable
    public synchronized V put(int key, @NotNull V value) throws StateException {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        V prevForwardValue = this.forwardHashMap.put(key, value);
        if (prevForwardValue != null) {
            this.reverseHashMap.remove((Object)prevForwardValue);
        }
        int prevReverseValue = this.reverseHashMap.get(value, this.defaultReturnValue);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != this.defaultReturnValue) {
            if (prevForwardValue != null) {
                this.forwardHashMap.put(key, prevForwardValue);
            } else {
                this.forwardHashMap.remove((Object)key);
            }
            this.reverseHashMap.put(value, prevReverseValue);
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        return prevForwardValue;
    }

    @Nullable
    public final synchronized V putForce(int key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        V prevForwardValue = this.forwardHashMap.put(key, value);
        if (prevForwardValue != null) {
            this.reverseHashMap.remove(prevForwardValue, this.defaultReturnValue);
        }
        int prevReverseValue = this.reverseHashMap.get(value, this.defaultReturnValue);
        this.reverseHashMap.put(value, key);
        if (prevReverseValue != this.defaultReturnValue) {
            this.forwardHashMap.remove((Object)prevReverseValue);
        }
        return prevForwardValue;
    }

    @Override
    public synchronized void putAll(@NotNull Map<? extends Integer, ? extends V> from) throws StateException {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        LockFreeIntBiMap<V> biMap = new LockFreeIntBiMap<V>();
        for (Map.Entry<Integer, V> entry : from.entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            V value = entry.getValue();
            biMap.put(key, value);
            if (this.forwardHashMap.containsKey((Object)key)) {
                throw new StateException("Key already exists. Keys and values must both be unique!");
            }
            if (!this.reverseHashMap.containsKey(value)) continue;
            throw new StateException("Value already exists. Keys and values must both be unique!");
        }
        this.forwardHashMap.putAll(biMap.forwardHashMap);
        this.reverseHashMap.putAll(biMap.reverseHashMap);
    }

    public final synchronized void putAllForce(@NotNull Map<Integer, ? extends V> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"hashMap");
        for (Map.Entry<Integer, V> entry : hashMap.entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            V value = entry.getValue();
            this.putForce(key, value);
        }
    }

    @Nullable
    public synchronized V remove(int key) {
        V value = this.forwardHashMap.remove((Object)key);
        if (value != null) {
            this.reverseHashMap.remove((Object)value);
        }
        return value;
    }

    @Nullable
    public V get(int key) {
        return (V)forwardREF.get(this).get((Object)key);
    }

    @Nullable
    public final Integer getReverse(@NotNull V key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ObjectIntMap<?> objectIntMap = reverseREF.get(this);
        Intrinsics.checkNotNullExpressionValue(objectIntMap, (String)"get(...)");
        return (Integer)((Map)objectIntMap).get(key);
    }

    @NotNull
    public Set<Map.Entry<Integer, V>> getEntries() {
        Set<Map.Entry<Integer, ?>> set = forwardREF.get(this).entrySet();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<kotlin.Int, V of dorkbox.collections.LockFreeIntBiMap>>");
        return TypeIntrinsics.asMutableSet(set);
    }

    @NotNull
    public Set<Integer> getKeys() {
        return forwardREF.get(this).keySet();
    }

    @NotNull
    public Collection<V> getValues() {
        Collection<?> collection = forwardREF.get(this).values();
        Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<V of dorkbox.collections.LockFreeIntBiMap>");
        return TypeIntrinsics.asMutableCollection(collection);
    }

    @Override
    public boolean isEmpty() {
        return forwardREF.get(this).isEmpty();
    }

    @NotNull
    public final Collection<Integer> getReverseValues() {
        return reverseREF.get(this).values();
    }

    @NotNull
    public final IntMap<V> toMap() {
        IntMap<?> intMap = forwardREF.get(this);
        Intrinsics.checkNotNull(intMap, (String)"null cannot be cast to non-null type dorkbox.collections.IntMap<V of dorkbox.collections.LockFreeIntBiMap>");
        return new IntMap(intMap);
    }

    @NotNull
    public final ObjectIntMap<V> toReverseMap() {
        ObjectIntMap<?> objectIntMap = reverseREF.get(this);
        Intrinsics.checkNotNull(objectIntMap, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectIntMap<V of dorkbox.collections.LockFreeIntBiMap>");
        return new ObjectIntMap(objectIntMap);
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rn\u0010\u0003\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\b\u001ab\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t \u0006*0\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\t0\t\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/collections/LockFreeIntBiMap$Companion;", "", "()V", "forwardREF", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Ldorkbox/collections/LockFreeIntBiMap;", "kotlin.jvm.PlatformType", "Ldorkbox/collections/IntMap;", "reverseREF", "Ldorkbox/collections/ObjectIntMap;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

