/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002JE\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\bj\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldorkbox/collections/QuickSelect;", "T", "", "()V", "array", "", "[Ljava/lang/Object;", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "medianOfThreePivot", "", "leftIdx", "rightIdx", "partition", "left", "right", "pivot", "recursiveSelect", "k", "select", "items", "n", "size", "([Ljava/lang/Object;Ljava/util/Comparator;II)I", "swap", "", "Companion", "Collections"})
public final class QuickSelect<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private T[] array;
    @Nullable
    private Comparator<? super T> comp;
    @NotNull
    public static final String version = "2.7";

    public final int select(@NotNull T[] items, @Nullable Comparator<T> comp, int n, int size) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.array = items;
        this.comp = comp;
        return this.recursiveSelect(0, size - 1, n);
    }

    private final int partition(int left, int right, int pivot) {
        T[] TArray = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray = null;
        }
        T pivotValue = TArray[pivot];
        this.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            Comparator<T> comparator = this.comp;
            Intrinsics.checkNotNull(comparator);
            T[] TArray2 = this.array;
            if (this.array == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"array");
                TArray2 = null;
            }
            if (comparator.compare(TArray2[i], pivotValue) >= 0) continue;
            this.swap(storage, i);
            ++storage;
        }
        this.swap(right, storage);
        return storage;
    }

    private final int recursiveSelect(int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = this.medianOfThreePivot(left, right);
        int pivotNewIndex = this.partition(left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = 0;
        result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? this.recursiveSelect(left, pivotNewIndex - 1, k) : this.recursiveSelect(pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    private final int medianOfThreePivot(int leftIdx, int rightIdx) {
        int n;
        T[] TArray = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray = null;
        }
        T left = TArray[leftIdx];
        int midIdx = (leftIdx + rightIdx) / 2;
        T[] TArray2 = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray2 = null;
        }
        T mid = TArray2[midIdx];
        T[] TArray3 = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray3 = null;
        }
        T right = TArray3[rightIdx];
        Comparator<T> comparator = this.comp;
        Intrinsics.checkNotNull(comparator);
        if (comparator.compare(left, mid) > 0) {
            Comparator<T> comparator2 = this.comp;
            Intrinsics.checkNotNull(comparator2);
            if (comparator2.compare(mid, right) > 0) {
                n = midIdx;
            } else {
                Comparator<T> comparator3 = this.comp;
                Intrinsics.checkNotNull(comparator3);
                n = comparator3.compare(left, right) > 0 ? rightIdx : leftIdx;
            }
        } else {
            Comparator<T> comparator4 = this.comp;
            Intrinsics.checkNotNull(comparator4);
            if (comparator4.compare(left, right) > 0) {
                n = leftIdx;
            } else {
                Comparator<T> comparator5 = this.comp;
                Intrinsics.checkNotNull(comparator5);
                n = comparator5.compare(mid, right) > 0 ? rightIdx : midIdx;
            }
        }
        return n;
    }

    private final void swap(int left, int right) {
        T[] TArray = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray = null;
        }
        T tmp = TArray[left];
        T[] TArray2 = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray2 = null;
        }
        T[] TArray3 = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray3 = null;
        }
        TArray2[left] = TArray3[right];
        T[] TArray4 = this.array;
        if (this.array == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"array");
            TArray4 = null;
        }
        TArray4[right] = tmp;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/QuickSelect$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

