/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.QuickSelect;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000eJA\u0010\u000f\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000eJG\u0010\u0010\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0012JG\u0010\u0013\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldorkbox/collections/Select;", "", "()V", "quickSelect", "Ldorkbox/collections/QuickSelect;", "fastMax", "", "T", "items", "", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "size", "([Ljava/lang/Object;Ljava/util/Comparator;I)I", "fastMin", "select", "kthLowest", "([Ljava/lang/Object;Ljava/util/Comparator;II)Ljava/lang/Object;", "selectIndex", "([Ljava/lang/Object;Ljava/util/Comparator;II)I", "Companion", "Collections"})
public final class Select {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QuickSelect<?> quickSelect;
    @NotNull
    public static final String version = "2.7";
    @Nullable
    private static Select instance;

    public final <T> T select(@NotNull T[] items, @NotNull Comparator<T> comp, int kthLowest, int size) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        int idx = this.selectIndex(items, comp, kthLowest, size);
        return items[idx];
    }

    public final <T> int selectIndex(@NotNull T[] items, @NotNull Comparator<T> comp, int kthLowest, int size) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = 0;
        if (kthLowest == 1) {
            idx = this.fastMin(items, comp, size);
        } else if (kthLowest == size) {
            idx = this.fastMax(items, comp, size);
        } else {
            if (this.quickSelect == null) {
                this.quickSelect = new QuickSelect();
            }
            QuickSelect<?> quickSelect = this.quickSelect;
            Intrinsics.checkNotNull(quickSelect);
            QuickSelect<?> quickSelect2 = quickSelect;
            idx = quickSelect2.select(items, comp, kthLowest, size);
        }
        return idx;
    }

    private final <T> int fastMin(T[] items, Comparator<T> comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items[i], items[lowestIdx]);
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private final <T> int fastMax(T[] items, Comparator<T> comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items[i], items[highestIdx]);
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldorkbox/collections/Select$Companion;", "", "()V", "instance", "Ldorkbox/collections/Select;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Select instance() {
            if (instance == null) {
                instance = new Select();
            }
            Select select = instance;
            Intrinsics.checkNotNull((Object)select);
            return select;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

