/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.desktop;

import dorkbox.executor.Executor;
import dorkbox.jna.linux.GnomeVFS;
import dorkbox.jna.linux.GtkCheck;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.os.OS;
import dorkbox.updates.Updates;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.SwingUtilities;

public class Desktop {
    private static final String GVFS = "/usr/bin/gvfs-open";
    private static final boolean GVFS_VALID = new File("/usr/bin/gvfs-open").canExecute();

    public static String getVersion() {
        return "1.1";
    }

    public static void open(final File file) throws IOException {
        if (file == null) {
            throw new IOException("File must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(file.toString());
        } else if (Desktop.awtSupported(Desktop.Action.OPEN)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `open`");
        }
    }

    public static void browseURL(String address) throws IOException {
        if (address == null || address.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            URI uri = new URI(address);
            Desktop.browseURL(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI " + address);
        }
    }

    public static void browseURL(final URI uri) throws IOException {
        if (uri == null) {
            throw new IOException("URI must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(uri.toString());
        } else if (Desktop.awtSupported(Desktop.Action.BROWSE)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().browse(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `browseURL`");
        }
    }

    public static void launchEmail(String address) throws IOException {
        if (address == null || address.isEmpty()) {
            throw new IOException("Address must not be null or empty.");
        }
        try {
            if (!address.startsWith("mailto:")) {
                address = "mailto:" + address;
            }
            URI uri = new URI(address);
            Desktop.launchEmail(uri);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI " + address);
        }
    }

    public static void launchEmail(final URI uri) throws IOException {
        if (uri == null) {
            throw new IOException("URI must not be null.");
        }
        if (Desktop.requireUnixLauncher()) {
            Desktop.launchNix(uri.toString());
        } else if (Desktop.awtSupported(Desktop.Action.MAIL)) {
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().mail(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `launchEmail`");
        }
    }

    public static void browseDirectory(String path) throws IOException {
        File directory;
        File[] files;
        if (path == null || path.isEmpty()) {
            throw new IOException("Path must not be null or empty.");
        }
        if (OS.INSTANCE.isMacOsX() && (files = (directory = new File(path)).listFiles()) != null && files.length > 0) {
            File child = files[0];
            new Executor().command(new String[]{"open", "-R", child.getCanonicalPath()}).startAsync();
        }
        if (Desktop.requireUnixLauncher()) {
            if (!path.contains("://")) {
                path = "file://" + path;
            }
            Desktop.launchNix(path);
        } else if (Desktop.awtSupported(Desktop.Action.OPEN)) {
            final String finalPath = path;
            Desktop.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        java.awt.Desktop.getDesktop().open(new File(finalPath));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            throw new IOException("Current OS and desktop configuration does not support `browseDirectory`");
        }
    }

    private static boolean requireUnixLauncher() {
        return (OS.INSTANCE.isUnix() || OS.INSTANCE.isLinux()) && GtkCheck.isGtkLoaded && GtkCheck.isGtk3;
    }

    private static boolean awtSupported(Desktop.Action action) {
        return java.awt.Desktop.isDesktopSupported() && java.awt.Desktop.getDesktop().isSupported(action);
    }

    private static void launchNix(final String path) throws IOException {
        if (GVFS_VALID) {
            new Executor().command(new String[]{GVFS, path}).startAsync();
        } else if (OS.DesktopEnv.INSTANCE.isGnome() && GnomeVFS.isInited) {
            GtkEventDispatch.dispatch((Runnable)new Runnable(){

                @Override
                public void run() {
                    int errorCode = GnomeVFS.gnome_vfs_url_show_with_env((String)path, null);
                    if (errorCode != 0) {
                        try {
                            new Executor().command(new String[]{"xdg-open", path}).startAsync();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            new Executor().command(new String[]{"xdg-open", path}).startAsync();
        }
    }

    private static void invokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        Updates.INSTANCE.add(Desktop.class, "3dc6a3bf880c4b388d07f07070dff520", Desktop.getVersion());
    }
}

