/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.AsApplication;
import dorkbox.notify.AsDesktop;
import dorkbox.notify.INotify;
import dorkbox.notify.Pos;
import dorkbox.notify.Theme;
import dorkbox.util.ActionHandler;
import dorkbox.util.ImageUtil;
import dorkbox.util.LocationResolver;
import dorkbox.util.Property;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class Notify {
    public static final String DIALOG_CONFIRM = "dialog-confirm.png";
    public static final String DIALOG_INFORMATION = "dialog-information.png";
    public static final String DIALOG_WARNING = "dialog-warning.png";
    public static final String DIALOG_ERROR = "dialog-error.png";
    @Property
    public static String TITLE_TEXT_FONT = "Source Code Pro BOLD 16";
    @Property
    public static String MAIN_TEXT_FONT = "Source Code Pro BOLD 12";
    @Property
    public static float MOVE_DURATION = 1.0f;
    @Property
    public static String IMAGE_PATH = "resources";
    private static Map<String, SoftReference<ImageIcon>> imageCache = new HashMap<String, SoftReference<ImageIcon>>(4);
    String title;
    String text;
    Theme theme;
    Pos position = Pos.BOTTOM_RIGHT;
    int hideAfterDurationInMillis = 0;
    boolean hideCloseButton;
    boolean isDark = false;
    int screenNumber = Short.MIN_VALUE;
    private ImageIcon icon;
    ActionHandler<Notify> onGeneralAreaClickAction;
    private INotify notifyPopup;
    private String name;
    private int shakeDurationInMillis = 0;
    private int shakeAmplitude = 0;
    private JFrame appWindow;

    public static String getVersion() {
        return "3.6";
    }

    public static Notify create() {
        return new Notify();
    }

    public static int getImageSize() {
        return 48;
    }

    public static void overrideDefaultImage(String imageName, BufferedImage image) {
        int height;
        if (imageCache.containsKey(imageName)) {
            throw new RuntimeException("Unable to set an image that already has been set. This action must be done as soon as possible.");
        }
        Image imageImmediate = ImageUtil.getImageImmediate(image);
        int width = imageImmediate.getWidth(null);
        BufferedImage bufferedImage = width > (height = imageImmediate.getHeight(null)) ? ImageUtil.resizeImage(image, Notify.getImageSize(), -1) : ImageUtil.resizeImage(image, -1, Notify.getImageSize());
        imageCache.put(imageName, new SoftReference<ImageIcon>(new ImageIcon(bufferedImage)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageIcon getImage(String imageName) {
        ImageIcon image = null;
        InputStream resourceAsStream = null;
        try {
            SoftReference<ImageIcon> reference = imageCache.get(imageName);
            if (reference != null) {
                image = reference.get();
            }
            if (image == null) {
                String name = IMAGE_PATH + File.separatorChar + imageName;
                resourceAsStream = LocationResolver.getResourceAsStream(name);
                image = new ImageIcon(ImageUtil.getImageImmediate(ImageIO.read(resourceAsStream)));
                imageCache.put(imageName, new SoftReference<ImageIcon>(image));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return image;
    }

    private Notify() {
    }

    public Notify text(String text) {
        this.text = text;
        return this;
    }

    public Notify title(String title) {
        this.title = title;
        return this;
    }

    public Notify image(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = ImageUtil.getBufferedImage(image);
        bufferedImage = width > height ? ImageUtil.resizeImage(bufferedImage, 48, -1) : ImageUtil.resizeImage(bufferedImage, -1, 48);
        bufferedImage = ImageUtil.clampMaxImageSize(bufferedImage, 48);
        bufferedImage = ImageUtil.getSquareBufferedImage(bufferedImage);
        this.icon = new ImageIcon(bufferedImage);
        return this;
    }

    public Notify position(Pos position) {
        this.position = position;
        return this;
    }

    public Notify hideAfter(int durationInMillis) {
        if (durationInMillis < 0) {
            durationInMillis = 0;
        }
        this.hideAfterDurationInMillis = durationInMillis;
        return this;
    }

    public Notify onAction(ActionHandler<Notify> onAction) {
        this.onGeneralAreaClickAction = onAction;
        return this;
    }

    public Notify darkStyle() {
        this.isDark = true;
        return this;
    }

    public Notify text(Theme theme) {
        this.theme = theme;
        return this;
    }

    public Notify hideCloseButton() {
        this.hideCloseButton = true;
        return this;
    }

    public void showWarning() {
        this.name = DIALOG_WARNING;
        this.icon = Notify.getImage(this.name);
        this.show();
    }

    public void showInformation() {
        this.name = DIALOG_INFORMATION;
        this.icon = Notify.getImage(this.name);
        this.show();
    }

    public void showError() {
        this.name = DIALOG_ERROR;
        this.icon = Notify.getImage(this.name);
        this.show();
    }

    public void showConfirm() {
        this.name = DIALOG_CONFIRM;
        this.icon = Notify.getImage(this.name);
        this.show();
    }

    public void show() {
        SwingUtil.invokeAndWaitQuietly(new Runnable(){

            @Override
            public void run() {
                Notify notify = Notify.this;
                ImageIcon image = notify.icon;
                Theme theme = notify.theme != null ? notify.theme : new Theme(TITLE_TEXT_FONT, MAIN_TEXT_FONT, notify.isDark);
                if (Notify.this.appWindow == null) {
                    Notify.this.notifyPopup = new AsDesktop(notify, image, theme);
                } else {
                    Notify.this.notifyPopup = new AsApplication(notify, image, Notify.this.appWindow, theme);
                }
                Notify.this.notifyPopup.setVisible(true);
                if (Notify.this.shakeDurationInMillis > 0) {
                    Notify.this.notifyPopup.shake(notify.shakeDurationInMillis, notify.shakeAmplitude);
                }
            }
        });
        this.icon = null;
    }

    public Notify shake(final int durationInMillis, final int amplitude) {
        this.shakeDurationInMillis = durationInMillis;
        this.shakeAmplitude = amplitude;
        if (this.notifyPopup != null) {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Notify.this.notifyPopup.shake(durationInMillis, amplitude);
                }
            });
        }
        return this;
    }

    public void close() {
        if (this.notifyPopup == null) {
            throw new NullPointerException("NotifyPopup");
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Notify.this.notifyPopup.close();
            }
        });
    }

    public Notify setScreen(int screenNumber) {
        this.screenNumber = screenNumber;
        return this;
    }

    public Notify attach(JFrame frame) {
        this.appWindow = frame;
        return this;
    }

    void onClose() {
        this.notifyPopup = null;
    }
}

