/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import dorkbox.objectPool.BoundedPoolObject;
import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import dorkbox.objectPool.SuspendingPool;
import dorkbox.objectPool.SuspendingPoolObject;
import dorkbox.objectPool.blocking.BlockingPool;
import dorkbox.objectPool.blocking.BlockingPoolCollection;
import dorkbox.objectPool.nonBlocking.BoundedNonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingPool;
import dorkbox.objectPool.nonBlocking.NonBlockingSoftPool;
import dorkbox.objectPool.suspending.ChannelQueue;
import dorkbox.objectPool.suspending.SuspendingPoolCollection;
import dorkbox.objectPool.suspending.SuspendingQueue;
import dorkbox.updates.Updates;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ6\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0011J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ2\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0013J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00152\u0006\u0010\u0016\u001a\u00020\rJ:\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00152\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0013J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ8\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00180\u0013JD\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001c2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ6\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001c2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0011J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001a\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldorkbox/objectPool/ObjectPool;", "", "()V", "version", "", "blocking", "Ldorkbox/objectPool/Pool;", "T", "poolObject", "Ldorkbox/objectPool/PoolObject;", "queue", "Ljava/util/concurrent/BlockingQueue;", "size", "", "initiallyFillPool", "", "collection", "", "nonBlocking", "Ljava/util/Queue;", "nonBlockingBounded", "Ldorkbox/objectPool/BoundedPoolObject;", "maxSize", "nonBlockingSoftReference", "Ljava/lang/ref/SoftReference;", "suspending", "Ldorkbox/objectPool/SuspendingPool;", "Ldorkbox/objectPool/SuspendingPoolObject;", "Ldorkbox/objectPool/suspending/SuspendingQueue;", "ObjectPool"})
public final class ObjectPool {
    @NotNull
    public static final ObjectPool INSTANCE = new ObjectPool();
    @NotNull
    public static final String version = "4.4";

    private ObjectPool() {
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.suspending(poolObject, size, new ChannelQueue(size), initiallyFillPool);
    }

    public static /* synthetic */ SuspendingPool suspending$default(ObjectPool objectPool, SuspendingPoolObject suspendingPoolObject, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return objectPool.suspending(suspendingPoolObject, n, bl);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingPoolObject<T> poolObject, int size, @NotNull SuspendingQueue<T> queue, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new dorkbox.objectPool.suspending.SuspendingPool<T>(poolObject, size, queue, initiallyFillPool);
    }

    public static /* synthetic */ SuspendingPool suspending$default(ObjectPool objectPool, SuspendingPoolObject suspendingPoolObject, int n, SuspendingQueue suspendingQueue, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return objectPool.suspending(suspendingPoolObject, n, suspendingQueue, bl);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.blocking(poolObject, (BlockingQueue)new DisruptorBlockingQueue(size), size, initiallyFillPool);
    }

    public static /* synthetic */ Pool blocking$default(ObjectPool objectPool, PoolObject poolObject, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return objectPool.blocking(poolObject, n, bl);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull PoolObject<T> poolObject, @NotNull BlockingQueue<T> queue, int size, boolean initiallyFillPool) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BlockingPool<T>(poolObject, queue, size, initiallyFillPool);
    }

    public static /* synthetic */ Pool blocking$default(ObjectPool objectPool, PoolObject poolObject, BlockingQueue blockingQueue, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return objectPool.blocking(poolObject, blockingQueue, n, bl);
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlocking(poolObject, new ConcurrentLinkedQueue());
    }

    @NotNull
    public final <T> Pool<T> nonBlocking(@NotNull PoolObject<T> poolObject, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlockingSoftReference(poolObject, new ConcurrentLinkedQueue());
    }

    @NotNull
    public final <T> Pool<T> nonBlockingSoftReference(@NotNull PoolObject<T> poolObject, @NotNull Queue<SoftReference<T>> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new NonBlockingSoftPool<T>(poolObject, queue);
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, int maxSize) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        return this.nonBlockingBounded(poolObject, maxSize, (Queue)new DisruptorBlockingQueue(maxSize));
    }

    @NotNull
    public final <T> Pool<T> nonBlockingBounded(@NotNull BoundedPoolObject<T> poolObject, int maxSize, @NotNull Queue<T> queue) {
        Intrinsics.checkNotNullParameter(poolObject, (String)"poolObject");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        return new BoundedNonBlockingPool<T>(poolObject, maxSize, queue);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return this.suspending(new ChannelQueue(collection.size()), collection);
    }

    @NotNull
    public final <T> SuspendingPool<T> suspending(@NotNull SuspendingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new SuspendingPoolCollection<T>(queue, collection);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return this.blocking((BlockingQueue)new DisruptorBlockingQueue(collection.size()), collection);
    }

    @NotNull
    public final <T> Pool<T> blocking(@NotNull BlockingQueue<T> queue, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new BlockingPoolCollection<T>(queue, collection);
    }

    static {
        Updates.INSTANCE.add(ObjectPool.class, "1dc60a2801d941cba9c7964255d8b061", version);
    }
}

