/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.headers.resources;

import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.headers.SectionTableEntry;
import dorkbox.peParser.headers.resources.ResourceDataEntry;
import dorkbox.peParser.headers.resources.ResourceDirectoryHeader;
import dorkbox.peParser.types.ByteDefinition;
import dorkbox.peParser.types.DWORD;
import dorkbox.peParser.types.ResourceDirName;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u0015\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry;", "Ldorkbox/peParser/headers/Header;", "bytes", "Ldorkbox/peParser/ByteArray;", "section", "Ldorkbox/peParser/headers/SectionTableEntry;", "level", "", "(Ldorkbox/peParser/ByteArray;Ldorkbox/peParser/headers/SectionTableEntry;I)V", "DATA_OFFSET", "Ldorkbox/peParser/types/DWORD;", "getDATA_OFFSET", "()Ldorkbox/peParser/types/DWORD;", "NAME", "Ldorkbox/peParser/types/ResourceDirName;", "getNAME", "()Ldorkbox/peParser/types/ResourceDirName;", "directory", "Ldorkbox/peParser/headers/resources/ResourceDirectoryHeader;", "getDirectory", "()Ldorkbox/peParser/headers/resources/ResourceDirectoryHeader;", "setDirectory", "(Ldorkbox/peParser/headers/resources/ResourceDirectoryHeader;)V", "isDirectory", "", "()Z", "(Z)V", "getLevel", "()I", "resourceDataEntry", "Ldorkbox/peParser/headers/resources/ResourceDataEntry;", "getResourceDataEntry", "()Ldorkbox/peParser/headers/resources/ResourceDataEntry;", "setResourceDataEntry", "(Ldorkbox/peParser/headers/resources/ResourceDataEntry;)V", "Companion", "PeParser"})
public final class ResourceDirectoryEntry
extends Header {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int level;
    @Nullable
    private final ResourceDirName NAME;
    @Nullable
    private final DWORD DATA_OFFSET;
    private boolean isDirectory;
    @Nullable
    private ResourceDirectoryHeader directory;
    @Nullable
    private ResourceDataEntry resourceDataEntry;
    public static final int HEADER_SIZE = 8;
    private static final int DATA_IS_DIRECTORY_MASK = Integer.MIN_VALUE;
    private static final int ENTRY_OFFSET_MASK = Integer.MAX_VALUE;

    public ResourceDirectoryEntry(@NotNull ByteArray bytes, @Nullable SectionTableEntry section, int level) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.level = level;
        this.NAME = (ResourceDirName)this.h((ByteDefinition)new ResourceDirName(bytes.readUInt-OGnWXxg(4), "name", bytes, this.level, null));
        this.DATA_OFFSET = (DWORD)this.h((ByteDefinition)new DWORD(bytes.readUInt-OGnWXxg(4), "data offset", null));
        long dataOffset = Integer.MAX_VALUE & ((long)this.DATA_OFFSET.get-pVg5ArA() & 0xFFFFFFFFL);
        if (dataOffset == 0L) {
            this.isDirectory = false;
        } else {
            if (dataOffset > Integer.MAX_VALUE) {
                throw new RuntimeException("Unable to set offset to more than 2gb!");
            }
            this.isDirectory = 0L != (Integer.MIN_VALUE & ((long)this.DATA_OFFSET.get-pVg5ArA() & 0xFFFFFFFFL));
            int saved = bytes.position();
            bytes.seek(bytes.marked() + (int)dataOffset);
            if (this.isDirectory) {
                this.directory = new ResourceDirectoryHeader(bytes, section, this.level);
            } else {
                SectionTableEntry sectionTableEntry = section;
                Intrinsics.checkNotNull((Object)sectionTableEntry);
                this.resourceDataEntry = new ResourceDataEntry(bytes, sectionTableEntry);
            }
            bytes.seek(saved);
        }
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final ResourceDirName getNAME() {
        return this.NAME;
    }

    @Nullable
    public final DWORD getDATA_OFFSET() {
        return this.DATA_OFFSET;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final void setDirectory(boolean bl) {
        this.isDirectory = bl;
    }

    @Nullable
    public final ResourceDirectoryHeader getDirectory() {
        return this.directory;
    }

    public final void setDirectory(@Nullable ResourceDirectoryHeader resourceDirectoryHeader) {
        this.directory = resourceDirectoryHeader;
    }

    @Nullable
    public final ResourceDataEntry getResourceDataEntry() {
        return this.resourceDataEntry;
    }

    public final void setResourceDataEntry(@Nullable ResourceDataEntry resourceDataEntry) {
        this.resourceDataEntry = resourceDataEntry;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldorkbox/peParser/headers/resources/ResourceDirectoryEntry$Companion;", "", "()V", "DATA_IS_DIRECTORY_MASK", "", "ENTRY_OFFSET_MASK", "HEADER_SIZE", "PeParser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

