/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage;

import com.esotericsoftware.kryo.Kryo;
import dorkbox.storage.Storage;
import dorkbox.storage.serializer.SerializerBytes;
import dorkbox.storage.types.MemoryStore;
import dorkbox.storage.types.PropertyStore;
import dorkbox.updates.Updates;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000 !2\u00020\u0001:\u0005 !\"#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH&J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u00a6\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\bH&J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u001e\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u00a6\u0002\u00a2\u0006\u0002\u0010\u0013J$\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u0002H\u0012H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001b\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u00a6\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0017H&J\b\u0010\u001e\u001a\u00020\u001fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Ldorkbox/storage/Storage;", "Ljava/lang/AutoCloseable;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "getLogger", "()Lorg/slf4j/Logger;", "close", "", "contains", "", "key", "", "delete", "deleteAll", "file", "Ljava/io/File;", "get", "V", "(Ljava/lang/Object;)Ljava/lang/Object;", "data", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "getVersion", "", "init", "initMessage", "", "set", "setVersion", "version", "size", "", "Builder", "Companion", "FileBuilder", "Memory", "Property", "Storage"})
public abstract class Storage
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String version = "1.11";
    @NotNull
    public static final String versionTag = "__VERSION__";
    @NotNull
    private static final Logger defaultLogger;

    public Storage(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void init(@NotNull String initMessage) {
        Intrinsics.checkNotNullParameter((Object)initMessage, (String)"initMessage");
        if (this.getVersion() == -1L) {
            this.setVersion(0L);
        }
        LoggerFactory.getLogger((String)"Storage").info(initMessage);
    }

    public final long getVersion() {
        Long l = (Long)this.get(versionTag);
        return l != null ? l : -1L;
    }

    public abstract void setVersion(long var1);

    @Nullable
    public abstract File file();

    public abstract int size();

    public abstract boolean contains(@NotNull Object var1);

    @Nullable
    public abstract <V> V get(@NotNull Object var1);

    public final <V> V get(@NotNull Object key, V data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        V current = this.get(key);
        if (current == null) {
            this.set(key, data);
            return data;
        }
        return current;
    }

    public abstract void set(@NotNull Object var1, @Nullable Object var2);

    public final void delete(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.set(key, null);
    }

    public abstract void deleteAll();

    @Override
    public abstract void close();

    public static final /* synthetic */ Logger access$getDefaultLogger$cp() {
        return defaultLogger;
    }

    static {
        Updates.INSTANCE.add(Storage.class, "c1281a7c576c4a9db0823763ff2fe811", version);
        NOPLogger nOPLogger = NOPLogger.NOP_LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)nOPLogger, (String)"NOP_LOGGER");
        defaultLogger = (Logger)nOPLogger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/storage/Storage$Companion;", "", "()V", "defaultLogger", "Lorg/slf4j/Logger;", "version", "", "versionTag", "Storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH&J\u00a4\u0001\u0010\t\u001a\u00020\u00002\u0099\u0001\u0010\t\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012E\u0012C\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\nj\u0002`\u0014H&J\u00a4\u0001\u0010\u0015\u001a\u00020\u00002\u0099\u0001\u0010\u0015\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012E\u0012C\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00120\nj\u0002`\u0014H&J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000bH&J\b\u0010\u0016\u001a\u00020\u0000H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0017"}, d2={"Ldorkbox/storage/Storage$Builder;", "", "isStringBased", "", "()Z", "build", "Ldorkbox/storage/Storage;", "logger", "Lorg/slf4j/Logger;", "onLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "onSave", "shared", "Storage"})
    public static interface Builder {
        public boolean isStringBased();

        @NotNull
        public Storage build();

        @NotNull
        public Builder shared();

        @NotNull
        public Builder onLoad(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> var1);

        @NotNull
        public Builder onSave(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> var1);

        @NotNull
        public Builder serializer(@NotNull SerializerBytes var1);

        @NotNull
        public Builder logger(@NotNull Logger var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 I*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010;\u001a\u00020\u000b2\b\u0010<\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0013\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010=J\u0013\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020>\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020AH\u0016J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010BJ\u001b\u0010C\u001a\u0002062\f\u0010D\u001a\b\u0012\u0004\u0012\u0002060EH\u0000\u00a2\u0006\u0002\bFJ\u00a4\u0001\u0010\u0013\u001a\u00020\u00022\u0099\u0001\u0010\u0013\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012E\u0012C\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001d0\u0014j\u0002`\u001fH\u0016J\u00a4\u0001\u0010$\u001a\u00020\u00022\u0099\u0001\u0010$\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012E\u0012C\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001d0\u0014j\u0002`\u001fH\u0016J\u000b\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010GJ\u000b\u0010H\u001a\u00028\u0000\u00a2\u0006\u0002\u0010GJ\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\r\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010GR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u00ab\u0001\u0010\u0013\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012E\u0012C\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001d0\u0014j\u0002`\u001fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u00ab\u0001\u0010$\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012E\u0012C\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0015\u0012\u0013\u0018\u00010\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u001d0\u0014j\u0002`\u001fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\f\"\u0004\b-\u0010*R\u001a\u0010\u0018\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\f\"\u0004\b4\u0010*R\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006J"}, d2={"Ldorkbox/storage/Storage$FileBuilder;", "B", "Ldorkbox/storage/Storage$Builder;", "()V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "isStringBased", "", "()Z", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "onLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "getOnLoad", "()Lkotlin/jvm/functions/Function4;", "setOnLoad", "(Lkotlin/jvm/functions/Function4;)V", "onSave", "getOnSave", "setOnSave", "readOnly", "getReadOnly", "setReadOnly", "(Z)V", "readOnlyViolent", "getReadOnlyViolent", "setReadOnlyViolent", "getSerializer", "()Ldorkbox/storage/serializer/SerializerBytes;", "setSerializer", "(Ldorkbox/storage/serializer/SerializerBytes;)V", "shared", "getShared", "setShared", "sharedBuild", "Ldorkbox/storage/Storage;", "getSharedBuild", "()Ldorkbox/storage/Storage;", "setSharedBuild", "(Ldorkbox/storage/Storage;)V", "equals", "other", "(Ljava/io/File;)Ldorkbox/storage/Storage$Builder;", "", "(Ljava/lang/String;)Ldorkbox/storage/Storage$Builder;", "hashCode", "", "(Lorg/slf4j/Logger;)Ldorkbox/storage/Storage$Builder;", "manageShared", "buildFun", "Lkotlin/Function0;", "manageShared$Storage", "()Ldorkbox/storage/Storage$Builder;", "readOnlyThrowExceptions", "Companion", "Storage"})
    public static abstract class FileBuilder<B extends Builder>
    implements Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private SerializerBytes serializer = defaultSerializer;
        private boolean shared;
        @Nullable
        private volatile Storage sharedBuild;
        @NotNull
        private Logger logger = Storage.access$getDefaultLogger$cp();
        @NotNull
        private File file = new File("storage.db");
        private boolean readOnly;
        private boolean readOnlyViolent;
        private final boolean isStringBased;
        @NotNull
        private static final SerializerBytes defaultSerializer = new SerializerBytes((Function1<? super Kryo, Unit>)((Function1)Companion.defaultSerializer.1.INSTANCE));

        @NotNull
        public abstract Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnLoad();

        public abstract void setOnLoad(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> var1);

        @NotNull
        public abstract Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnSave();

        public abstract void setOnSave(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> var1);

        @NotNull
        public final SerializerBytes getSerializer() {
            return this.serializer;
        }

        public final void setSerializer(@NotNull SerializerBytes serializerBytes) {
            Intrinsics.checkNotNullParameter((Object)serializerBytes, (String)"<set-?>");
            this.serializer = serializerBytes;
        }

        public final boolean getShared() {
            return this.shared;
        }

        public final void setShared(boolean bl) {
            this.shared = bl;
        }

        @Nullable
        public final Storage getSharedBuild() {
            return this.sharedBuild;
        }

        public final void setSharedBuild(@Nullable Storage storage) {
            this.sharedBuild = storage;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final void setLogger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
            this.logger = logger;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final void setFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
            this.file = file;
        }

        public final boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(boolean bl) {
            this.readOnly = bl;
        }

        public final boolean getReadOnlyViolent() {
            return this.readOnlyViolent;
        }

        public final void setReadOnlyViolent(boolean bl) {
            this.readOnlyViolent = bl;
        }

        @Override
        public boolean isStringBased() {
            return this.isStringBased;
        }

        @NotNull
        public final Storage manageShared$Storage(@NotNull Function0<? extends Storage> buildFun) {
            Storage storage;
            Intrinsics.checkNotNullParameter(buildFun, (String)"buildFun");
            if (this.shared) {
                if (this.sharedBuild == null) {
                    this.sharedBuild = (Storage)buildFun.invoke();
                }
                Storage storage2 = this.sharedBuild;
                storage = storage2;
                Intrinsics.checkNotNull((Object)storage2);
            } else {
                storage = (Storage)buildFun.invoke();
            }
            return storage;
        }

        @NotNull
        public B shared() {
            this.shared = true;
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type B of dorkbox.storage.Storage.FileBuilder");
            return (B)this;
        }

        @Override
        @NotNull
        public Builder onLoad(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad) {
            Intrinsics.checkNotNullParameter(onLoad, (String)"onLoad");
            this.setOnLoad(onLoad);
            return this;
        }

        @Override
        @NotNull
        public Builder onSave(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave) {
            Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
            this.setOnSave(onSave);
            return this;
        }

        @Override
        @NotNull
        public Builder serializer(@NotNull SerializerBytes serializer) {
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            this.serializer = serializer;
            return this;
        }

        @NotNull
        public B logger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type B of dorkbox.storage.Storage.FileBuilder");
            return (B)this;
        }

        @NotNull
        public final B file(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type B of dorkbox.storage.Storage.FileBuilder");
            return (B)this;
        }

        @NotNull
        public final B file(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.file(new File(file));
        }

        @NotNull
        public final B readOnly() {
            this.readOnly = true;
            this.readOnlyViolent = false;
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type B of dorkbox.storage.Storage.FileBuilder");
            return (B)this;
        }

        @NotNull
        public final B readOnlyThrowExceptions() {
            this.readOnly = true;
            this.readOnlyViolent = true;
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type B of dorkbox.storage.Storage.FileBuilder");
            return (B)this;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileBuilder)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getOnLoad(), ((FileBuilder)other).getOnLoad())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getOnSave(), ((FileBuilder)other).getOnSave())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serializer, (Object)((FileBuilder)other).serializer)) {
                return false;
            }
            if (this.shared != ((FileBuilder)other).shared) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sharedBuild, (Object)((FileBuilder)other).sharedBuild)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logger, (Object)((FileBuilder)other).logger)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)((FileBuilder)other).file)) {
                return false;
            }
            if (this.readOnly != ((FileBuilder)other).readOnly) {
                return false;
            }
            if (this.readOnlyViolent != ((FileBuilder)other).readOnlyViolent) {
                return false;
            }
            return this.isStringBased() == ((FileBuilder)other).isStringBased();
        }

        public int hashCode() {
            int result = this.getOnLoad().hashCode();
            result = 31 * result + this.getOnSave().hashCode();
            result = 31 * result + this.serializer.hashCode();
            result = 31 * result + Boolean.hashCode(this.shared);
            Storage storage = this.sharedBuild;
            result = 31 * result + (storage != null ? storage.hashCode() : 0);
            result = 31 * result + this.logger.hashCode();
            result = 31 * result + this.file.hashCode();
            result = 31 * result + Boolean.hashCode(this.readOnly);
            result = 31 * result + Boolean.hashCode(this.readOnlyViolent);
            result = 31 * result + Boolean.hashCode(this.isStringBased());
            return result;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/storage/Storage$FileBuilder$Companion;", "", "()V", "defaultSerializer", "Ldorkbox/storage/serializer/SerializerBytes;", "Storage"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0013\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u00a4\u0001\u0010\u0011\u001a\u00020\u00012\u0099\u0001\u0010\u0011\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012E\u0012C\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001a0\u0012j\u0002`\u001cH\u0016J\u00a4\u0001\u0010\u001d\u001a\u00020\u00012\u0099\u0001\u0010\u001d\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012E\u0012C\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0017\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001a0\u0012j\u0002`\u001cH\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldorkbox/storage/Storage$Memory;", "Ldorkbox/storage/Storage$Builder;", "()V", "isStringBased", "", "()Z", "logger", "Lorg/slf4j/Logger;", "shared", "sharedBuild", "Ldorkbox/storage/Storage;", "build", "equals", "other", "", "hashCode", "", "onLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "onSave", "Storage"})
    public static final class Memory
    implements Builder {
        @NotNull
        private Logger logger = Storage.access$getDefaultLogger$cp();
        private boolean shared;
        @Nullable
        private volatile Storage sharedBuild;
        private final boolean isStringBased;

        public Memory() {
            this.isStringBased = true;
        }

        @Override
        public boolean isStringBased() {
            return this.isStringBased;
        }

        @Override
        @NotNull
        public Storage build() {
            Storage storage;
            if (this.shared) {
                if (this.sharedBuild == null) {
                    this.sharedBuild = new MemoryStore(this.logger);
                }
                Storage storage2 = this.sharedBuild;
                storage = storage2;
                Intrinsics.checkNotNull((Object)storage2);
            } else {
                storage = new MemoryStore(this.logger);
            }
            return storage;
        }

        @Override
        @NotNull
        public Memory shared() {
            this.shared = true;
            return this;
        }

        @Override
        @NotNull
        public Builder onLoad(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad) {
            Intrinsics.checkNotNullParameter(onLoad, (String)"onLoad");
            return this;
        }

        @Override
        @NotNull
        public Builder onSave(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave) {
            Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
            return this;
        }

        @Override
        @NotNull
        public Builder serializer(@NotNull SerializerBytes serializer) {
            Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
            return this;
        }

        @Override
        @NotNull
        public Builder logger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            return this;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Memory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.logger, (Object)((Memory)other).logger)) {
                return false;
            }
            if (this.shared != ((Memory)other).shared) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sharedBuild, (Object)((Memory)other).sharedBuild)) {
                return false;
            }
            return this.isStringBased() == ((Memory)other).isStringBased();
        }

        public int hashCode() {
            int result = this.logger.hashCode();
            result = 31 * result + Boolean.hashCode(this.shared);
            Storage storage = this.sharedBuild;
            result = 31 * result + (storage != null ? storage.hashCode() : 0);
            result = 31 * result + Boolean.hashCode(this.isStringBased());
            return result;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u00ad\u0001\u0010\u0007\u001a\u0094\u0001\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012E\u0012C\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00110\bj\u0002`\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u00ad\u0001\u0010\u0018\u001a\u0094\u0001\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012E\u0012C\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00110\bj\u0002`\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006#"}, d2={"Ldorkbox/storage/Storage$Property;", "Ldorkbox/storage/Storage$FileBuilder;", "()V", "autoLoad", "", "isStringBased", "()Z", "onLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "getOnLoad", "()Lkotlin/jvm/functions/Function4;", "setOnLoad", "(Lkotlin/jvm/functions/Function4;)V", "onSave", "getOnSave", "setOnSave", "autoLoadChanges", "build", "Ldorkbox/storage/Storage;", "equals", "other", "hashCode", "", "Companion", "Storage"})
    public static final class Property
    extends FileBuilder<Property> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean autoLoad;
        @NotNull
        private Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad = defaultOnLoad;
        @NotNull
        private Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave = defaultOnSave;
        private final boolean isStringBased;
        @NotNull
        private static final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> defaultOnLoad = Companion.defaultOnLoad.1.INSTANCE;
        @NotNull
        private static final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> defaultOnSave = Companion.defaultOnSave.1.INSTANCE;

        public Property() {
            this.isStringBased = true;
        }

        @Override
        @NotNull
        public Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnLoad() {
            return this.onLoad;
        }

        @Override
        public void setOnLoad(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> function4) {
            Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
            this.onLoad = function4;
        }

        @Override
        @NotNull
        public Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnSave() {
            return this.onSave;
        }

        @Override
        public void setOnSave(@NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> function4) {
            Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
            this.onSave = function4;
        }

        @Override
        public boolean isStringBased() {
            return this.isStringBased;
        }

        @Override
        @NotNull
        public Storage build() {
            return this.manageShared$Storage((Function0<Storage>)((Function0)new Function0<Storage>(this){
                final /* synthetic */ Property this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Storage invoke() {
                    File file = this.this$0.getFile().getAbsoluteFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file.absoluteFile");
                    return new PropertyStore(file, Property.access$getAutoLoad$p(this.this$0), this.this$0.getReadOnly(), this.this$0.getReadOnlyViolent(), this.this$0.getLogger(), this.this$0.getSerializer(), this.this$0.getOnLoad(), this.this$0.getOnSave());
                }
            }));
        }

        @NotNull
        public final Property autoLoadChanges() {
            this.autoLoad = true;
            return this;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Property)) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            if (this.autoLoad != ((Property)other).autoLoad) {
                return false;
            }
            return this.isStringBased() == ((Property)other).isStringBased();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Boolean.hashCode(this.autoLoad);
            result = 31 * result + Boolean.hashCode(this.isStringBased());
            return result;
        }

        public static final /* synthetic */ boolean access$getAutoLoad$p(Property $this) {
            return $this.autoLoad;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u00a4\u0001\u0010\u0003\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012E\u0012C\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u00a4\u0001\u0010\u0011\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012E\u0012C\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\u0001\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ldorkbox/storage/Storage$Property$Companion;", "", "()V", "defaultOnLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "getDefaultOnLoad", "()Lkotlin/jvm/functions/Function4;", "defaultOnSave", "getDefaultOnSave", "Storage"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getDefaultOnLoad() {
                return defaultOnLoad;
            }

            @NotNull
            public final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getDefaultOnSave() {
                return defaultOnSave;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

