/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage.serializer;

import com.esotericsoftware.kryo.Kryo;
import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.Pool;
import dorkbox.objectPool.PoolObject;
import dorkbox.storage.serializer.KryoBytes;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001e\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\u001c\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldorkbox/storage/serializer/SerializerBytes;", "", "onNewKryoSerializer", "Lkotlin/Function1;", "Lcom/esotericsoftware/kryo/Kryo;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "kryoPool", "Ldorkbox/objectPool/Pool;", "Ldorkbox/storage/serializer/KryoBytes;", "deserialize", "T", "bytes", "", "([B)Ljava/lang/Object;", "serialize", "object", "type", "Ljava/lang/Class;", "Companion", "Storage"})
public final class SerializerBytes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pool<KryoBytes> kryoPool;
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerBytes.class);

    public SerializerBytes(@NotNull Function1<? super Kryo, Unit> onNewKryoSerializer) {
        Intrinsics.checkNotNullParameter(onNewKryoSerializer, (String)"onNewKryoSerializer");
        PoolObject<KryoBytes> poolObject2 = new PoolObject<KryoBytes>(onNewKryoSerializer){
            final /* synthetic */ Function1<Kryo, Unit> $onNewKryoSerializer;
            {
                this.$onNewKryoSerializer = $onNewKryoSerializer;
            }

            @NotNull
            public KryoBytes newInstance() {
                KryoBytes kryoBytes = new KryoBytes();
                kryoBytes.register(String.class);
                kryoBytes.register(Long.TYPE);
                this.$onNewKryoSerializer.invoke((Object)((Object)kryoBytes));
                return kryoBytes;
            }
        };
        this.kryoPool = ObjectPool.INSTANCE.nonBlocking((PoolObject)poolObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@Nullable Object object) throws Exception {
        byte[] byArray;
        KryoBytes kryo = (KryoBytes)((Object)this.kryoPool.take());
        try {
            byte[] byArray2 = kryo.write(object).toBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            kryo.write\u2026ect`).toBytes()\n        }");
            byArray = byArray2;
        }
        catch (Exception e) {
            LOGGER.error("Error while serializing the object.", (Throwable)e);
            throw e;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@Nullable Object object, @NotNull Class<?> type) throws Exception {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        KryoBytes kryo = (KryoBytes)((Object)this.kryoPool.take());
        try {
            byte[] byArray2 = kryo.writeObject(object).toBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            kryo.write\u2026ect`).toBytes()\n        }");
            byArray = byArray2;
        }
        catch (Exception e) {
            LOGGER.error("Error while serializing the object.", (Throwable)e);
            throw e;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T deserialize(@NotNull byte[] bytes) throws Exception {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        KryoBytes kryo = (KryoBytes)((Object)this.kryoPool.take());
        try {
            if (!(bytes.length == 0)) {
                Object object = kryo.read(bytes);
                return (T)object;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while deserializing the bytes.", (Throwable)e);
            throw e;
        }
        finally {
            this.kryoPool.put((Object)kryo);
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/storage/serializer/SerializerBytes$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

