/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage.types;

import dorkbox.json.Json;
import dorkbox.json.JsonException;
import dorkbox.json.OutputType;
import dorkbox.storage.Storage;
import dorkbox.storage.serializer.SerializerBytes;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\u00e5\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0099\u0001\u0010\n\u001a\u0094\u0001\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\u000bj\u0002`\u0016\u0012\u0099\u0001\u0010\u0017\u001a\u0094\u0001\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\u000bj\u0002`\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010(\u001a\u00020\u0014H\u0016J\u0011\u0010)\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002J\b\u0010*\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J\u001e\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010.J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J\u001b\u00100\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u00101\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0010\u00102\u001a\u00020\u00142\u0006\u0010'\u001a\u00020 H\u0016J\b\u00103\u001a\u000204H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001aR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ldorkbox/storage/types/JsonStore;", "Ldorkbox/storage/Storage;", "dbFile", "Ljava/io/File;", "autoLoad", "", "readOnly", "readOnlyViolent", "logger", "Lorg/slf4j/Logger;", "onLoad", "Lkotlin/Function4;", "Ldorkbox/storage/serializer/SerializerBytes;", "Lkotlin/ParameterName;", "name", "serializer", "", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "onSave", "(Ljava/io/File;ZZZLorg/slf4j/Logger;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function4;)V", "getAutoLoad", "()Z", "getDbFile", "()Ljava/io/File;", "json", "Ldorkbox/json/Json;", "lastModifiedTime", "", "loadedProps", "Ljava/util/concurrent/ConcurrentHashMap;", "getReadOnly", "getReadOnlyViolent", "thread", "Ljava/lang/Thread;", "version", "close", "contains", "deleteAll", "file", "get", "V", "(Ljava/lang/Object;)Ljava/lang/Object;", "save", "set", "data", "setVersion", "size", "", "Companion", "Storage"})
@SourceDebugExtension(value={"SMAP\nJsonStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonStore.kt\ndorkbox/storage/types/JsonStore\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,229:1\n215#2,2:230\n*S KotlinDebug\n*F\n+ 1 JsonStore.kt\ndorkbox/storage/types/JsonStore\n*L\n82#1:230,2\n*E\n"})
public final class JsonStore
extends Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dbFile;
    private final boolean autoLoad;
    private final boolean readOnly;
    private final boolean readOnlyViolent;
    private long version;
    @NotNull
    private final Thread thread;
    @NotNull
    private final Json json;
    private volatile long lastModifiedTime;
    @NotNull
    private final ConcurrentHashMap<Object, Object> loadedProps;
    @NotNull
    private static final Comparator<Object> comparator = JsonStore::comparator$lambda$7;

    public JsonStore(@NotNull File dbFile, boolean autoLoad, boolean readOnly, boolean readOnlyViolent, @NotNull Logger logger, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(onLoad, (String)"onLoad");
        Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
        super(logger);
        this.dbFile = dbFile;
        this.autoLoad = autoLoad;
        this.readOnly = readOnly;
        this.readOnlyViolent = readOnlyViolent;
        this.thread = new Thread(() -> JsonStore.thread$lambda$0(this));
        this.json = new Json();
        this.loadedProps = new ConcurrentHashMap();
        this.json.setOutputType(OutputType.json);
        this.load();
        Object versionInfo = this.loadedProps.get("__VERSION__");
        if (!(versionInfo instanceof Number)) {
            ((Map)this.loadedProps).put("__VERSION__", this.version);
        } else {
            this.setVersion((Long)versionInfo);
        }
        Runtime.getRuntime().addShutdownHook(this.thread);
        this.init("Property file storage initialized at: '" + this.dbFile + '\'');
    }

    @NotNull
    public final File getDbFile() {
        return this.dbFile;
    }

    public final boolean getAutoLoad() {
        return this.autoLoad;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final boolean getReadOnlyViolent() {
        return this.readOnlyViolent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        if (!(this.dbFile.canRead() || this.dbFile.getParentFile().mkdirs() || this.dbFile.createNewFile())) {
            throw new IOException("Cannot create file");
        }
        try {
            File file = this.dbFile;
            synchronized (file) {
                Map map;
                boolean bl = false;
                Map map2 = map = (Map)this.json.fromJson(HashMap.class, this.dbFile);
                if (map2 != null) {
                    Map $this$forEach$iv = map2;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl2 = false;
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        ((Map)this.loadedProps).put(k, v);
                    }
                }
                this.lastModifiedTime = this.dbFile.lastModified();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (JsonException e) {
            this.getLogger().error("Cannot load JSON file!", (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("Cannot load JSON file!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save() {
        if (this.readOnly) {
            return;
        }
        if (!(this.dbFile.canRead() || this.dbFile.getParentFile().mkdirs() || this.dbFile.createNewFile())) {
            throw new IOException("Cannot create file");
        }
        try {
            File file = this.dbFile;
            synchronized (file) {
                boolean bl = false;
                String data = Json.toJson$default((Json)this.json, this.loadedProps, null, null, (int)6, null);
                String pretty = Json.prettyPrint$default((Json)this.json, (String)data, (int)0, (int)2, null);
                FilesKt.writeText$default((File)this.dbFile, (String)pretty, null, (int)2, null);
                this.lastModifiedTime = this.dbFile.lastModified();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (JsonException e) {
            this.getLogger().error("JSON cannot save to: " + this.dbFile, (Throwable)e);
        }
        catch (IOException e) {
            this.getLogger().error("JSON cannot save to: " + this.dbFile, (Throwable)e);
        }
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    @NotNull
    public File file() {
        return this.dbFile;
    }

    @Override
    public int size() {
        return this.loadedProps.size();
    }

    @Override
    public boolean contains(@NotNull Object key) {
        long lastModifiedTime;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof String)) {
            boolean bl = false;
            String string = "Keys for a json file must be a String";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.autoLoad && this.lastModifiedTime != (lastModifiedTime = this.dbFile.lastModified())) {
            this.load();
        }
        return this.loadedProps.get(key) != null;
    }

    @Override
    @Nullable
    public <V> V get(@NotNull Object key) {
        Object any;
        long lastModifiedTime;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof String)) {
            boolean bl = false;
            String string = "Keys for a json file must be a String";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.autoLoad && this.lastModifiedTime != (lastModifiedTime = this.dbFile.lastModified())) {
            this.load();
        }
        if ((any = this.loadedProps.get(key)) != null) {
            return (V)any;
        }
        return null;
    }

    @Override
    public void set(@NotNull Object key, @Nullable Object data) {
        Object prev;
        boolean hasChanged;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof String)) {
            boolean $i$a$-require-JsonStore$set$22 = false;
            String $i$a$-require-JsonStore$set$22 = "Keys for a json file must be a String";
            throw new IllegalArgumentException($i$a$-require-JsonStore$set$22.toString());
        }
        if (this.readOnly) {
            if (this.readOnlyViolent) {
                throw new IOException("Unable to save data in " + this.dbFile + " for " + key + " : " + data);
            }
            return;
        }
        boolean bl = data == null ? this.loadedProps.remove(key) != null : (hasChanged = (prev = this.loadedProps.put(key, data)) != data);
        if (hasChanged) {
            this.save();
        }
    }

    @Override
    public void deleteAll() {
        if (this.readOnly) {
            if (this.readOnlyViolent) {
                throw new IOException("Unable to delete all data in " + this.dbFile);
            }
            return;
        }
        this.loadedProps.clear();
        this.dbFile.delete();
    }

    @Override
    public void close() {
        if (!Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.thread)) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.thread);
            }
            catch (Exception exception) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.save();
    }

    private static final void thread$lambda$0(JsonStore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.close();
    }

    private static final int comparator$lambda$7(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/storage/types/JsonStore$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

