/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage.types;

import dorkbox.storage.Storage;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0096\u0002J\b\u0010\r\u001a\u00020\tH\u0016J\u0013\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001e\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001b\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldorkbox/storage/types/MemoryStore;", "Ldorkbox/storage/Storage;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "close", "", "contains", "", "key", "deleteAll", "equals", "other", "file", "Ljava/io/File;", "get", "V", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "", "set", "data", "setVersion", "version", "", "size", "toString", "", "Storage"})
public final class MemoryStore
extends Storage {
    @NotNull
    private final ConcurrentHashMap<Object, Object> map;

    public MemoryStore(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(logger);
        this.map = new ConcurrentHashMap();
        this.init("Memory storage initialized");
    }

    @Override
    public void setVersion(long version) {
        this.set("__VERSION__", version);
    }

    @Override
    @Nullable
    public File file() {
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.map.contains(key);
    }

    @Override
    @Nullable
    public <V> V get(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (V)this.map.get(key);
    }

    @Override
    public void set(@NotNull Object key, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            this.map.remove(key);
        } else {
            ((Map)this.map).put(key, data);
        }
    }

    @Override
    public void deleteAll() {
        this.map.clear();
    }

    @Override
    public void close() {
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryStore)) {
            return false;
        }
        return Intrinsics.areEqual(this.map, ((MemoryStore)other).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @NotNull
    public String toString() {
        return "MemoryStore(map=" + this.map.hashCode() + ')';
    }
}

