/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage.types;

import dorkbox.storage.serializer.SerializerBytes;
import dorkbox.storage.types.PropertyStore;
import dorkbox.storage.types.StringStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u001a\u0018\u00002\u00020\u0001B\u00ed\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0099\u0001\u0010\f\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u0012\u0099\u0001\u0010\u0017\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0013\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006&"}, d2={"Ldorkbox/storage/types/PropertyStore;", "Ldorkbox/storage/types/StringStore;", "dbFile", "Ljava/io/File;", "autoLoad", "", "readOnly", "readOnlyViolent", "logger", "Lorg/slf4j/Logger;", "serializer", "Ldorkbox/storage/serializer/SerializerBytes;", "onLoad", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "onSave", "(Ljava/io/File;ZZZLorg/slf4j/Logger;Ldorkbox/storage/serializer/SerializerBytes;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function4;)V", "propertiesOnDisk", "dorkbox/storage/types/PropertyStore$propertiesOnDisk$1", "Ldorkbox/storage/types/PropertyStore$propertiesOnDisk$1;", "close", "deleteAll", "doLoad", "doSave", "equals", "other", "hashCode", "", "toString", "", "Storage"})
@SourceDebugExtension(value={"SMAP\nPropertyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyStore.kt\ndorkbox/storage/types/PropertyStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1855#2,2:138\n*S KotlinDebug\n*F\n+ 1 PropertyStore.kt\ndorkbox/storage/types/PropertyStore\n*L\n76#1:138,2\n*E\n"})
public final class PropertyStore
extends StringStore {
    @NotNull
    private final propertiesOnDisk.1 propertiesOnDisk;

    public PropertyStore(@NotNull File dbFile, boolean autoLoad, boolean readOnly, boolean readOnlyViolent, @NotNull Logger logger, @NotNull SerializerBytes serializer, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(onLoad, (String)"onLoad");
        Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
        super(dbFile, autoLoad, readOnly, readOnlyViolent, logger, serializer, onLoad, onSave);
        this.propertiesOnDisk = new Properties(this){
            final /* synthetic */ PropertyStore this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Enumeration<Object> keys() {
                Enumeration<Object> keysEnum = super.keys();
                Vector<Object> vector = new Vector<Object>(this.this$0.size());
                while (keysEnum.hasMoreElements()) {
                    vector.add(keysEnum.nextElement());
                }
                CollectionsKt.sortWith((List)vector, StringStore.Companion.getComparator$Storage());
                Enumeration<Object> enumeration = vector.elements();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"vector.elements()");
                return enumeration;
            }
        };
        this.load();
        this.init("Property file storage initialized at: '" + dbFile + '\'');
    }

    @Override
    public void onSave(@NotNull Object key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.propertiesOnDisk).put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLoad() {
        Closeable closeable = new FileInputStream(this.getDbFile());
        Throwable throwable = null;
        try {
            FileInputStream fileStream = (FileInputStream)closeable;
            boolean bl = false;
            this.propertiesOnDisk.load(fileStream);
            Set<Map.Entry<Object, Object>> set = this.propertiesOnDisk.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"propertiesOnDisk.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(k, v)");
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (Intrinsics.areEqual(k, (Object)"__VERSION__")) {
                    Function2<Object, Object, Unit> function2 = this.getLoadFunc();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"k");
                    Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                    function2.invoke(k, (Object)Long.parseLong((String)v));
                    ((Map)this.propertiesOnDisk).put(k, v);
                    continue;
                }
                try {
                    ((Map)this.propertiesOnDisk).put(k, v);
                    Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> function4 = this.getOnLoad();
                    SerializerBytes serializerBytes = this.getSerializer();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"k");
                    function4.invoke((Object)serializerBytes, k, v, this.getLoadFunc());
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to parse property (" + this.getDbFile() + ") [" + k + "] : " + v, (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave() {
        Closeable closeable = new FileOutputStream(this.getDbFile(), false);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            this.propertiesOnDisk.store(fos, "Storage Version: " + this.getVersion());
            fos.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void deleteAll() {
        super.deleteAll();
        this.propertiesOnDisk.clear();
    }

    @Override
    public void close() {
        super.close();
        this.propertiesOnDisk.clear();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyStore)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.propertiesOnDisk, (Object)((PropertyStore)other).propertiesOnDisk);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.propertiesOnDisk.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "PropertyStore(file=" + this.propertiesOnDisk + ')';
    }
}

