/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.storage.types;

import dorkbox.storage.Storage;
import dorkbox.storage.serializer.SerializerBytes;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u0000 C2\u00020\u0001:\u0001CB\u00ed\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0099\u0001\u0010\f\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u0012\u0099\u0001\u0010\u0017\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u00100\u001a\u00020\u0014H\u0016J\u0011\u00101\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002J\b\u00102\u001a\u00020\u0014H\u0016J\b\u00103\u001a\u00020\u0014H&J\b\u00104\u001a\u00020\u0014H&J\u0013\u00105\u001a\u00020\u00052\b\u00106\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u00107\u001a\u00020\u0003H\u0016J\u001e\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020<H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0004J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H&J\b\u0010=\u001a\u00020\u0014H\u0002J\u001a\u0010=\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002J\u001b\u0010>\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010?\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010A\u001a\u00020\u001fH\u0016J\b\u0010B\u001a\u00020<H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000RF\u0010 \u001a4\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00a4\u0001\u0010\f\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u00a4\u0001\u0010\u0017\u001a\u0094\u0001\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012E\u0012C\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00140\rj\u0002`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001aRF\u0010*\u001a4\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Ldorkbox/storage/types/StringStore;", "Ldorkbox/storage/Storage;", "dbFile", "Ljava/io/File;", "autoLoad", "", "readOnly", "readOnlyViolent", "logger", "Lorg/slf4j/Logger;", "serializer", "Ldorkbox/storage/serializer/SerializerBytes;", "onLoad", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "", "key", "value", "Lkotlin/Function2;", "", "load", "Ldorkbox/storage/AccessFunc;", "onSave", "(Ljava/io/File;ZZZLorg/slf4j/Logger;Ldorkbox/storage/serializer/SerializerBytes;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function4;)V", "getAutoLoad", "()Z", "getDbFile", "()Ljava/io/File;", "isDirty", "lastModifiedTime", "", "loadFunc", "getLoadFunc", "()Lkotlin/jvm/functions/Function2;", "loadedProps", "Ljava/util/concurrent/ConcurrentHashMap;", "getOnLoad", "()Lkotlin/jvm/functions/Function4;", "getOnSave", "getReadOnly", "getReadOnlyViolent", "saveFunc", "getSaveFunc", "getSerializer", "()Ldorkbox/storage/serializer/SerializerBytes;", "thread", "Ljava/lang/Thread;", "close", "contains", "deleteAll", "doLoad", "doSave", "equals", "other", "file", "get", "V", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "", "save", "set", "data", "setVersion", "version", "size", "Companion", "Storage"})
@SourceDebugExtension(value={"SMAP\nStringStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringStore.kt\ndorkbox/storage/types/StringStore\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,292:1\n215#2,2:293\n*S KotlinDebug\n*F\n+ 1 StringStore.kt\ndorkbox/storage/types/StringStore\n*L\n137#1:293,2\n*E\n"})
public abstract class StringStore
extends Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dbFile;
    private final boolean autoLoad;
    private final boolean readOnly;
    private final boolean readOnlyViolent;
    @NotNull
    private final SerializerBytes serializer;
    @NotNull
    private final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> onLoad;
    @NotNull
    private final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> onSave;
    @NotNull
    private final Thread thread;
    private volatile long lastModifiedTime;
    private volatile boolean isDirty;
    @NotNull
    private final Function2<Object, Object, Unit> loadFunc;
    @NotNull
    private final Function2<Object, Object, Unit> saveFunc;
    @NotNull
    private final ConcurrentHashMap<Object, Object> loadedProps;
    @NotNull
    private static final Comparator<Object> comparator = StringStore::comparator$lambda$5;

    public StringStore(@NotNull File dbFile, boolean autoLoad, boolean readOnly, boolean readOnlyViolent, @NotNull Logger logger, @NotNull SerializerBytes serializer, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onLoad, @NotNull Function4<? super SerializerBytes, Object, Object, ? super Function2<Object, Object, Unit>, Unit> onSave) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(onLoad, (String)"onLoad");
        Intrinsics.checkNotNullParameter(onSave, (String)"onSave");
        super(logger);
        this.dbFile = dbFile;
        this.autoLoad = autoLoad;
        this.readOnly = readOnly;
        this.readOnlyViolent = readOnlyViolent;
        this.serializer = serializer;
        this.onLoad = onLoad;
        this.onSave = onSave;
        this.thread = new Thread(() -> StringStore.thread$lambda$0(this));
        this.loadedProps = new ConcurrentHashMap();
        this.loadFunc = (Function2)new Function2<Object, Object, Unit>(){

            public final void invoke(@NotNull Object key, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ((Map)loadedProps).put(key, value);
            }
        };
        this.saveFunc = (Function2)new Function2<Object, Object, Unit>(){

            public final void invoke(@NotNull Object key, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                this.onSave(key, value);
            }
        };
        Runtime.getRuntime().addShutdownHook(this.thread);
    }

    @NotNull
    public final File getDbFile() {
        return this.dbFile;
    }

    public final boolean getAutoLoad() {
        return this.autoLoad;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final boolean getReadOnlyViolent() {
        return this.readOnlyViolent;
    }

    @NotNull
    public final SerializerBytes getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnLoad() {
        return this.onLoad;
    }

    @NotNull
    public final Function4<SerializerBytes, Object, Object, Function2<Object, Object, Unit>, Unit> getOnSave() {
        return this.onSave;
    }

    @NotNull
    protected final Function2<Object, Object, Unit> getLoadFunc() {
        return this.loadFunc;
    }

    @NotNull
    protected final Function2<Object, Object, Unit> getSaveFunc() {
        return this.saveFunc;
    }

    public abstract void onSave(@NotNull Object var1, @Nullable Object var2);

    public abstract void doLoad();

    public abstract void doSave();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void load() {
        if (!(this.dbFile.canRead() || this.dbFile.getParentFile().mkdirs() || this.dbFile.createNewFile())) {
            throw new IOException("Cannot create file");
        }
        try {
            File file = this.dbFile;
            synchronized (file) {
                boolean bl = false;
                this.lastModifiedTime = this.dbFile.lastModified();
                this.doLoad();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (IOException e) {
            this.getLogger().error("Cannot load properties!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save(Object key, Object value) {
        if (this.readOnly) {
            return;
        }
        if (!(this.dbFile.canRead() || this.dbFile.getParentFile().mkdirs() || this.dbFile.createNewFile())) {
            throw new IOException("Cannot create file");
        }
        try {
            File file = this.dbFile;
            synchronized (file) {
                boolean bl = false;
                if (value != null) {
                    try {
                        this.onSave.invoke((Object)this.serializer, key, value, this.saveFunc);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to parse property (" + this.dbFile + ") [" + key + "] : " + value, (Throwable)e);
                    }
                } else {
                    this.saveFunc.invoke(key, null);
                }
                this.doSave();
                this.lastModifiedTime = this.dbFile.lastModified();
                Unit unit = Unit.INSTANCE;
            }
            this.isDirty = false;
        }
        catch (IOException e) {
            this.getLogger().error("Properties cannot save to: " + this.dbFile, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void save() {
        if (this.readOnly || !this.isDirty) {
            return;
        }
        if (!(this.dbFile.canRead() || this.dbFile.getParentFile().mkdirs() || this.dbFile.createNewFile())) {
            throw new IOException("Cannot create file");
        }
        try {
            File file = this.dbFile;
            synchronized (file) {
                boolean bl = false;
                Map $this$forEach$iv = this.loadedProps;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (Intrinsics.areEqual(k, (Object)"__VERSION__")) {
                        this.save(k, String.valueOf(v));
                        continue;
                    }
                    try {
                        this.onSave.invoke((Object)this.serializer, k, v, this.saveFunc);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to parse property (" + this.dbFile + ") [" + k + "] : " + v, (Throwable)e);
                    }
                }
                this.doSave();
                this.lastModifiedTime = this.dbFile.lastModified();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (IOException e) {
            this.getLogger().error("Properties cannot save to: " + this.dbFile, (Throwable)e);
        }
    }

    @Override
    public void setVersion(long version) {
        if (!this.readOnly) {
            this.set("__VERSION__", version);
        }
    }

    @Override
    @NotNull
    public File file() {
        return this.dbFile;
    }

    @Override
    public int size() {
        return this.loadedProps.size();
    }

    @Override
    public boolean contains(@NotNull Object key) {
        long lastModifiedTime;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.autoLoad && this.lastModifiedTime != (lastModifiedTime = this.dbFile.lastModified())) {
            this.load();
        }
        return this.loadedProps.get(key) != null;
    }

    @Override
    @Nullable
    public <V> V get(@NotNull Object key) {
        Object any;
        long lastModifiedTime;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.autoLoad && this.lastModifiedTime != (lastModifiedTime = this.dbFile.lastModified())) {
            this.load();
        }
        if ((any = this.loadedProps.get(key)) != null) {
            return (V)any;
        }
        return null;
    }

    @Override
    public void set(@NotNull Object key, @Nullable Object data) {
        Object prev;
        boolean hasChanged;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.readOnly) {
            if (this.readOnlyViolent) {
                throw new IOException("Unable to save data in " + this.dbFile + " for " + key + " : " + data);
            }
            return;
        }
        boolean bl = data == null ? this.loadedProps.remove(key) != null : (hasChanged = (prev = this.loadedProps.put(key, data)) != data);
        if (hasChanged) {
            this.isDirty = true;
            this.save(key, data);
        }
    }

    @Override
    public void deleteAll() {
        if (this.readOnly) {
            if (this.readOnlyViolent) {
                throw new IOException("Unable to delete all data in " + this.dbFile);
            }
            return;
        }
        this.loadedProps.clear();
        this.dbFile.delete();
    }

    @Override
    public void close() {
        if (!Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this.thread)) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.thread);
            }
            catch (Exception exception) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.save();
        this.loadedProps.clear();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringStore)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dbFile, (Object)((StringStore)other).dbFile)) {
            return false;
        }
        if (this.autoLoad != ((StringStore)other).autoLoad) {
            return false;
        }
        if (this.readOnly != ((StringStore)other).readOnly) {
            return false;
        }
        if (this.readOnlyViolent != ((StringStore)other).readOnlyViolent) {
            return false;
        }
        if (this.lastModifiedTime != ((StringStore)other).lastModifiedTime) {
            return false;
        }
        if (this.isDirty != ((StringStore)other).isDirty) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serializer, (Object)((StringStore)other).serializer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onLoad, ((StringStore)other).onLoad)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onSave, ((StringStore)other).onSave)) {
            return false;
        }
        return Intrinsics.areEqual(this.loadedProps, ((StringStore)other).loadedProps);
    }

    public int hashCode() {
        int result = this.dbFile.hashCode();
        result = 31 * result + Boolean.hashCode(this.autoLoad);
        result = 31 * result + Boolean.hashCode(this.readOnly);
        result = 31 * result + Boolean.hashCode(this.readOnlyViolent);
        result = 31 * result + Long.hashCode(this.lastModifiedTime);
        result = 31 * result + Boolean.hashCode(this.isDirty);
        result = 31 * result + this.serializer.hashCode();
        result = 31 * result + this.onLoad.hashCode();
        result = 31 * result + this.onSave.hashCode();
        result = 31 * result + this.loadedProps.hashCode();
        return result;
    }

    private static final void thread$lambda$0(StringStore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.close();
    }

    private static final int comparator$lambda$5(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldorkbox/storage/types/StringStore$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "getComparator$Storage", "()Ljava/util/Comparator;", "Storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Object> getComparator$Storage() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

