/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.gnomeShell.ExtensionSupport;
import java.io.File;
import java.util.List;

public class AppIndicatorExtension
extends ExtensionSupport {
    private static final String UID = "appindicatorsupport@rgcjonas.gmail.com";

    public static boolean isInstalled() {
        List<String> enabledExtensions = AppIndicatorExtension.getEnabledExtensions();
        return enabledExtensions.contains(UID);
    }

    public static void install() {
        boolean success;
        String gnomeVersion;
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing the appindicator gnome-shell extension.");
        }
        if ((gnomeVersion = ExtensionSupport.getGnomeVersion()) == null) {
            return;
        }
        List<String> enabledExtensions = AppIndicatorExtension.getEnabledExtensions();
        boolean isInstalled = enabledExtensions.contains(UID);
        String userHome = System.getProperty("user.home");
        File directory = new File(userHome + "/.local/share/gnome-shell/extensions/" + UID);
        File metaDatafile = new File(directory, "metadata.json");
        String metadata = ExtensionSupport.createMetadata(UID, SystemTray.getVersion(), gnomeVersion);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Checking the appindicator gnome-shell extension");
        }
        if (isInstalled && !ExtensionSupport.needsUpgrade(metadata, metaDatafile)) {
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing appindicator gnome-shell extension");
        }
        if (success = ExtensionSupport.writeFile(metadata, metaDatafile)) {
            ExtensionSupport.installZip("appindicator.zip", directory);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Enabling appindicator gnome-shell extension");
            }
            if (!enabledExtensions.contains(UID)) {
                enabledExtensions.add(UID);
            }
            AppIndicatorExtension.setEnabledExtensions(enabledExtensions);
        }
    }

    public static void unInstall() {
        AppIndicatorExtension.unInstall(UID, null);
    }
}

