/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.jna.linux.GCallback;
import dorkbox.util.jna.linux.GObject;
import dorkbox.util.jna.linux.Gtk;
import dorkbox.util.jna.linux.GtkEventDispatch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItem
extends GtkBaseMenuItem
implements MenuItemPeer,
GCallback {
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';

    GtkMenuItem(GtkMenu parent) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
        GObject.g_signal_connect_object(this._native, "activate", this, null, 0);
    }

    @Override
    public int callback(Pointer instance, Pointer data) {
        ActionListener callback = this.callback;
        if (callback != null) {
            GtkEventDispatch.proxyClick(callback);
        }
        return 1;
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        final boolean hadImage = this.hasImage();
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkMenuItem.this.image != null) {
                    Gtk.Gtk2.gtk_container_remove(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    GtkMenuItem.this.image = null;
                }
                if (menuItem.getImage() != null) {
                    GtkMenuItem.this.removeSpacerImage();
                    GtkMenuItem.this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                    Gtk.Gtk2.gtk_image_menu_item_set_image(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(GtkMenuItem.this._native, true);
                } else if (hadImage) {
                    GtkMenuItem.this.addSpacerImage();
                }
                Gtk.Gtk2.gtk_widget_show_all(GtkMenuItem.this._native);
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_widget_set_sensitive(GtkMenuItem.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_menu_item_set_label(GtkMenuItem.this._native, textWithMnemonic);
                Gtk.Gtk2.gtk_widget_show_all(GtkMenuItem.this._native);
            }
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                            }
                            catch (Throwable throwable) {
                                SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                            }
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        this.mnemonicKey = Character.toLowerCase(menuItem.getShortcut());
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(final MenuItem menuItem) {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.Gtk2.gtk_widget_set_tooltip_text(GtkMenuItem.this._native, menuItem.getTooltip());
            }
        });
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(new Runnable(){

            @Override
            public void run() {
                GtkMenuItem.super.remove();
                GtkMenuItem.this.callback = null;
                Gtk.Gtk2.gtk_container_remove(((GtkMenuItem)GtkMenuItem.this).parent._nativeMenu, GtkMenuItem.this._native);
                if (GtkMenuItem.this.image != null) {
                    Gtk.Gtk2.gtk_container_remove(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    GtkMenuItem.this.image = null;
                }
                GtkMenuItem.this.parent.remove(GtkMenuItem.this);
            }
        });
    }
}

