/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.ui.swing.SwingUIFactory;
import dorkbox.systemTray.util.HeavyCheckMark;
import dorkbox.util.swing.DefaultMenuItemUI;
import dorkbox.util.swing.DefaultPopupMenuUI;
import dorkbox.util.swing.DefaultSeparatorUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.SeparatorUI;
import javax.swing.plaf.metal.MetalBorders;

public class LinuxSwingUI
implements SwingUIFactory {
    private static PopupMenuUI popupMenuUI = null;
    private static MenuItemUI menuItemUI = null;
    private static SeparatorUI separatorUI = null;

    @Override
    public PopupMenuUI getMenuUI(JPopupMenu jPopupMenu, Menu entry) {
        return new DefaultPopupMenuUI(jPopupMenu){

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                JPopupMenu popupMenu = (JPopupMenu)c;
                popupMenu.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        };
    }

    @Override
    public MenuItemUI getItemUI(JMenuItem jMenuItem, Entry entry) {
        return new DefaultMenuItemUI(jMenuItem){

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                JMenuItem menuItem = (JMenuItem)c;
                menuItem.setIconTextGap(8);
                c.setBorder(new Metal_MenuItemBorder(4));
            }
        };
    }

    @Override
    public SeparatorUI getSeparatorUI(JSeparator jSeparator) {
        return new DefaultSeparatorUI(jSeparator);
    }

    @Override
    public String getCheckMarkIcon(Color color, int checkMarkSize, int targetImageSize) {
        return HeavyCheckMark.get(color, checkMarkSize, targetImageSize);
    }

    public static class Metal_MenuItemBorder
    extends MetalBorders.MenuItemBorder {
        private final int verticalPadding;

        Metal_MenuItemBorder(int verticalPadding) {
            this.verticalPadding = verticalPadding;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.set(this.verticalPadding, 2, this.verticalPadding, 2);
            return newInsets;
        }
    }
}

